/*
 * Decompiled with CFR 0.152.
 */
package com.highgo.jdbc.geometric;

import com.highgo.jdbc.util.ByteConverter;
import com.highgo.jdbc.util.GT;
import com.highgo.jdbc.util.PGBinaryObject;
import com.highgo.jdbc.util.PGobject;
import com.highgo.jdbc.util.PGtokenizer;
import com.highgo.jdbc.util.PSQLException;
import com.highgo.jdbc.util.PSQLState;
import java.awt.Point;
import java.io.Serializable;
import java.sql.SQLException;
import org.checkerframework.checker.nullness.qual.Nullable;

public class PGpoint
extends PGobject
implements PGBinaryObject,
Serializable,
Cloneable {
    public double x;
    public double y;

    public PGpoint(double x, double y) {
        this();
        this.x = x;
        this.y = y;
    }

    public PGpoint(String value) throws SQLException {
        this();
        this.setValue(value);
    }

    public PGpoint() {
        this.type = "point";
    }

    @Override
    public void setValue(String s) throws SQLException {
        PGtokenizer t = new PGtokenizer(PGtokenizer.removePara(s), ',');
        try {
            this.x = Double.parseDouble(t.getToken(0));
            this.y = Double.parseDouble(t.getToken(1));
        }
        catch (NumberFormatException e) {
            throw new PSQLException(GT.tr("Conversion to type {0} failed: {1}.", this.type, s), PSQLState.DATA_TYPE_MISMATCH, (Throwable)e);
        }
    }

    @Override
    public void setByteValue(byte[] b, int offset) {
        this.x = ByteConverter.float8(b, offset);
        this.y = ByteConverter.float8(b, offset + 8);
    }

    @Override
    public boolean equals(@Nullable Object obj) {
        if (obj instanceof PGpoint) {
            PGpoint p = (PGpoint)obj;
            return this.x == p.x && this.y == p.y;
        }
        return false;
    }

    @Override
    public int hashCode() {
        long v1 = Double.doubleToLongBits(this.x);
        long v2 = Double.doubleToLongBits(this.y);
        return (int)(v1 ^ v2 ^ v1 >>> 32 ^ v2 >>> 32);
    }

    @Override
    public String getValue() {
        return "(" + this.x + "," + this.y + ")";
    }

    @Override
    public int lengthInBytes() {
        return 16;
    }

    @Override
    public void toBytes(byte[] b, int offset) {
        ByteConverter.float8(b, offset, this.x);
        ByteConverter.float8(b, offset + 8, this.y);
    }

    public void translate(int x, int y) {
        this.translate((double)x, (double)y);
    }

    public void translate(double x, double y) {
        this.x += x;
        this.y += y;
    }

    public void move(int x, int y) {
        this.setLocation(x, y);
    }

    public void move(double x, double y) {
        this.x = x;
        this.y = y;
    }

    public void setLocation(int x, int y) {
        this.move((double)x, (double)y);
    }

    public void setLocation(Point p) {
        this.setLocation(p.x, p.y);
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

