/*
 * Decompiled with CFR 0.152.
 */
package com.hipoom.hook.adapter.pine;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.hipoom.hook.adapter.FrameContext;
import com.hipoom.hook.adapter.HookParams;
import com.hipoom.hook.adapter.IHookStyle;
import java.lang.reflect.Constructor;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import top.canyie.pine.Pine;
import top.canyie.pine.callback.MethodHook;

public class PineHookStyle
implements IHookStyle {
    public void hook(final @NonNull HookParams options) {
        Class classObj = options.getHookClass().getClassObj();
        Set<Member> needHookMembers = this.generateNeedHookMembers(classObj, options);
        for (Member member : needHookMembers) {
            Pine.hook((Member)member, (MethodHook)new MethodHook(){

                public void beforeCall(Pine.CallFrame callFrame) throws Throwable {
                    super.beforeCall(callFrame);
                    options.getHookCallback().doBefore(PineHookStyle.this.convertCallFrame2FrameContext(callFrame));
                }

                public void afterCall(Pine.CallFrame callFrame) throws Throwable {
                    super.afterCall(callFrame);
                    options.getHookCallback().doAfter(PineHookStyle.this.convertCallFrame2FrameContext(callFrame));
                }
            });
        }
    }

    @NonNull
    private Set<Member> generateNeedHookMembers(@NonNull Class<?> classObj, @NonNull HookParams options) {
        String methodName = options.getMethodName();
        if ("<init>".equals(methodName)) {
            return this.generateNeedHookMembers4Constructor(classObj, options);
        }
        return this.generateNeedHookMembers4Method(classObj, options);
    }

    @NonNull
    private Set<Member> generateNeedHookMembers4Constructor(@NonNull Class<?> classObj, @NonNull HookParams options) {
        Class[] types = options.getParametersType();
        if (HookParams.PARAMS_TYPE_ALL == types) {
            Constructor<?>[] constructors = classObj.getDeclaredConstructors();
            return new HashSet<Member>(Arrays.asList(constructors));
        }
        try {
            Constructor<?> constructor = classObj.getDeclaredConstructor(types);
            HashSet<Member> res = new HashSet<Member>();
            res.add(constructor);
            return res;
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }

    @NonNull
    private Set<Member> generateNeedHookMembers4Method(@NonNull Class<?> classObj, @NonNull HookParams options) {
        Class[] types = options.getParametersType();
        if (HookParams.PARAMS_TYPE_ALL == types) {
            Method[] methods = classObj.getDeclaredMethods();
            return new HashSet<Member>(Arrays.asList(methods));
        }
        try {
            Method method = classObj.getDeclaredMethod(options.getMethodName(), types);
            HashSet<Member> res = new HashSet<Member>();
            res.add(method);
            return res;
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }

    @NonNull
    private FrameContext convertCallFrame2FrameContext(final @NonNull Pine.CallFrame callFrame) {
        return new FrameContext(){

            @NonNull
            public Member getMember() {
                return callFrame.method;
            }

            @Nullable
            public Object getSelf() {
                return callFrame.thisObject;
            }

            @Nullable
            public Object[] getArgs() {
                return callFrame.args;
            }

            @Nullable
            public Object getResult() {
                return callFrame.getResult();
            }
        };
    }
}

