/*
 * Decompiled with CFR 0.152.
 */
package com.hipoom.hook;

import androidx.annotation.NonNull;
import androidx.annotation.RestrictTo;
import com.hipoom.hook.HookAction;
import com.hipoom.hook.HookActionHolder;
import com.hipoom.hook.adapter.HookStyleFactory;
import com.hipoom.hook.adapter.IHookStyle;

public abstract class AbsIntent {
    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public Class<?> needHookClass;
    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public HookActionHolder actionsHolder;

    public AbsIntent(Class<?> needHookClass) {
        this.needHookClass = needHookClass;
        this.actionsHolder = new HookActionHolder(needHookClass);
    }

    public AbsIntent doBefore(@NonNull HookAction action) {
        this.actionsHolder.doBefore(action);
        return this;
    }

    public AbsIntent doAfter(@NonNull HookAction action) {
        this.actionsHolder.doAfter(action);
        return this;
    }

    public AbsIntent logWhenCall(boolean needPrintTrace) {
        this.actionsHolder.logWhenCall(needPrintTrace);
        return this;
    }

    public void hook() {
        IHookStyle hooker = HookStyleFactory.getAnyOne();
        if (hooker == null) {
            throw new IllegalStateException("\u627e\u4e0d\u5230\u4efb\u4f55 HookStyle \u7684\u5b9e\u73b0\u3002");
        }
        this.onHook(hooker);
    }

    protected abstract void onHook(@NonNull IHookStyle var1);
}

