/*
 * Decompiled with CFR 0.152.
 */
package com.hipoom.hook;

import android.util.Log;
import androidx.annotation.NonNull;
import com.hipoom.hook.HookAction;
import com.hipoom.hook.ParamsTransformer;
import com.hipoom.hook.adapter.FrameContext;
import com.hipoom.hook.adapter.HookCallback;
import java.lang.reflect.Constructor;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.Arrays;
import kotlin.collections.ArraysKt;

public class HookActionHolder {
    Class<?> needHookClass;
    HookAction onBeforeAction;
    HookAction onAfterAction;
    HookAction logWhenCallAction;

    public HookActionHolder(Class<?> needHookClass) {
        this.needHookClass = needHookClass;
    }

    public void doBefore(@NonNull HookAction action) {
        this.onBeforeAction = action;
    }

    public void doAfter(@NonNull HookAction action) {
        this.onAfterAction = action;
    }

    public void logWhenCall(boolean needPrintTrace) {
        this.logWhenCallAction = context -> {
            Member member = context.getMember();
            String methodName = member.getName();
            Class<?> classObj = member.getDeclaringClass();
            Object[] args = context.getArgs();
            StringBuilder sb = new StringBuilder();
            Class<?>[] types = null;
            if (member instanceof Method) {
                types = ((Method)member).getParameterTypes();
            } else if (member instanceof Constructor) {
                types = ((Constructor)member).getParameterTypes();
            } else {
                throw new IllegalStateException("\u672a\u77e5\u7684 Member \u7c7b\u578b.");
            }
            for (int i = 0; i < types.length; ++i) {
                if (args == null || args.length <= i) {
                    sb.append("null, ");
                    continue;
                }
                String des = ParamsTransformer.defaultImpl.transform(types[i], args[i]);
                sb.append(des).append(", ");
            }
            if (sb.toString().endsWith(", ")) {
                sb.deleteCharAt(sb.length() - 1);
                sb.deleteCharAt(sb.length() - 1);
            }
            String msg = this.needHookClass.getSimpleName() + "#" + methodName + "(" + sb + ") \u88ab\u6267\u884c\u4e86";
            if (needPrintTrace) {
                String trace = HookActionHolder.dumpTrace(8);
                Log.i((String)"JavaHook", (String)(msg + "\uff0c\u8c03\u7528\u5806\u6808\u662f: \n" + trace));
            } else {
                Log.i((String)"JavaHook", (String)msg);
            }
        };
    }

    @NonNull
    public HookCallback getHookCallback() {
        return new HookCallback(){

            public void doBefore(@NonNull FrameContext context) {
                if (HookActionHolder.this.logWhenCallAction != null) {
                    HookActionHolder.this.logWhenCallAction.onAction(context);
                }
                if (HookActionHolder.this.onBeforeAction != null) {
                    HookActionHolder.this.onBeforeAction.onAction(context);
                }
            }

            public void doAfter(@NonNull FrameContext context) {
                if (HookActionHolder.this.onAfterAction != null) {
                    HookActionHolder.this.onAfterAction.onAction(context);
                }
            }
        };
    }

    public static String dumpTrace(int depth) {
        Object[] traces = Log.getStackTraceString((Throwable)new Throwable()).split("\n");
        traces = Arrays.copyOfRange(traces, depth, traces.length);
        return ArraysKt.joinToString((Object[])traces, (CharSequence)"\n", (CharSequence)"", (CharSequence)"", (int)Integer.MAX_VALUE, (CharSequence)"", s -> s);
    }
}

