/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.adapter.sdk.api.annotations;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.FIELD, ElementType.METHOD})
public @interface ModuleConfigField {
    @Nullable
    public String title() default "";

    @Nullable
    public String description() default "";

    @Nullable
    public FieldType format() default FieldType.UNSPECIFIED;

    @Nullable
    public String defaultValue() default "";

    public double multipleOf() default 0.0;

    public double numberMin() default 4.9E-324;

    public double numberMax() default 1.7976931348623157E308;

    public int stringMinLength() default 0;

    public int stringMaxLength() default 0x7FFFFFFF;

    @Nullable
    public String stringPattern() default "";

    public String @NotNull [] enumDisplayValues() default {};

    public boolean required() default false;

    public boolean ignore() default false;

    public int arrayMinItems() default 0;

    public int arrayMaxItems() default 0x7FFFFFFF;

    public boolean readOnly() default false;

    public boolean writeOnly() default false;

    public boolean arrayUniqueItems() default false;

    public String @NotNull [] allowedValues() default {};

    public CustomAttribute @NotNull [] customAttributes() default {};

    public static enum FieldType {
        DATE("date"),
        TIME("time"),
        DATE_TIME("date-time"),
        REGEX("regex"),
        EMAIL("email"),
        HOSTNAME("hostname"),
        IPV4("ipv4"),
        IPV6("ipv6"),
        JSON_POINTER("json-pointer"),
        RELATIVE_JSON_POINTER("relative-json-pointer"),
        URI("uri"),
        UNSPECIFIED("unspecified"),
        IDENTIFIER("identifier"),
        BOOLEAN("boolean"),
        MQTT_TOPIC("mqtt-topic");

        @NotNull
        private final String name;

        private FieldType(String name) {
            this.name = name;
        }

        @NotNull
        public String getName() {
            return this.name;
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.ANNOTATION_TYPE})
    public static @interface CustomAttribute {
        @NotNull
        public String name();

        @NotNull
        public String value();
    }
}

