/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.adapter.sdk.api.events.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.hivemq.adapter.sdk.api.events.model.Payload;
import com.hivemq.adapter.sdk.api.events.model.TypeIdentifier;
import io.swagger.v3.oas.annotations.media.Schema;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface Event {
    @JsonProperty(value="severity")
    @Schema(description="The severity that this log is considered to be", required=true)
    @NotNull
    public SEVERITY getSeverity();

    @JsonProperty(value="message")
    @Schema(description="The message associated with the event. A message will be no more than 1024 characters in length", type="string", required=true)
    @NotNull
    public String getMessage();

    @JsonProperty(value="payload")
    @Schema(description="Object to denote the payload of the event")
    @Nullable
    public Payload getPayload();

    @JsonProperty(value="timestamp")
    @Schema(description="Time the event was generated in epoch format", required=true)
    @NotNull
    public Long getTimestamp();

    @JsonProperty(value="created")
    @Schema(type="string", format="date-time", description="Time the event was in date format", required=true)
    @NotNull
    public Long getCreated();

    @Nullable
    public TypeIdentifier getAssociatedObject();

    @Nullable
    public TypeIdentifier getSource();

    @JsonProperty(value="identifier")
    @Schema(description="The unique id of the event object", required=true)
    @NotNull
    public TypeIdentifier getIdentifier();

    public static enum SEVERITY {
        INFO,
        WARN,
        ERROR,
        CRITICAL;

    }
}

