/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.adapter.sdk.api.events.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import org.jetbrains.annotations.NotNull;

public interface Payload {
    @JsonProperty(value="contentType")
    @Schema(description="The content type of the payload that the event contains", required=true)
    @NotNull
    public ContentType getContentType();

    @JsonProperty(value="content")
    @Schema(description="The content of the payload encoded as a string")
    @NotNull
    public String getContent();

    public static enum ContentType {
        JSON("application/json"),
        PLAIN_TEXT("text/plain"),
        XML("text/xml"),
        CSV("text/csv");

        @JsonProperty(value="contentType")
        @Schema(description="The official representation of the content type")
        @NotNull
        final String contentType;

        private ContentType(String contentType) {
            this.contentType = contentType;
        }

        @NotNull
        public String getContentType() {
            return this.contentType;
        }
    }
}

