/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.extension.sdk.api.services;

import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.extension.sdk.api.annotations.Nullable;
import com.hivemq.extension.sdk.api.services.interceptor.EdgeInterceptorRegistry;
import java.util.Map;

public class EdgeServices {
    private static final String NO_ACCESS_MESSAGE = "Static class EdgeServices cannot be called from a thread \"%s\" which does not have a HiveMQ extension classloader as its context classloader.";
    private static @Nullable Map<String, @NotNull Object> edgeServices;

    @NotNull
    public static EdgeInterceptorRegistry edgeInterceptorRegistry() {
        return EdgeServices.getClassObject(EdgeInterceptorRegistry.class);
    }

    @NotNull
    private static <T> T getClassObject(@NotNull Class<T> clazz) {
        if (edgeServices == null) {
            throw new RuntimeException(String.format(NO_ACCESS_MESSAGE, Thread.currentThread().getName()));
        }
        Object object = edgeServices.get(clazz.getCanonicalName());
        if (object == null) {
            throw new RuntimeException(String.format(NO_ACCESS_MESSAGE, Thread.currentThread().getName()));
        }
        if (clazz.isInstance(object)) {
            return (T)object;
        }
        throw new RuntimeException(String.format(NO_ACCESS_MESSAGE, Thread.currentThread().getName()));
    }
}

