/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.extension.sdk.api.services;

import com.codahale.metrics.MetricRegistry;
import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.extension.sdk.api.annotations.Nullable;
import com.hivemq.extension.sdk.api.events.EventRegistry;
import com.hivemq.extension.sdk.api.services.ManagedExtensionExecutorService;
import com.hivemq.extension.sdk.api.services.auth.SecurityRegistry;
import com.hivemq.extension.sdk.api.services.cluster.ClusterService;
import com.hivemq.extension.sdk.api.services.intializer.InitializerRegistry;
import com.hivemq.extension.sdk.api.services.publish.PublishService;
import com.hivemq.extension.sdk.api.services.publish.RetainedMessageStore;
import com.hivemq.extension.sdk.api.services.session.ClientService;
import com.hivemq.extension.sdk.api.services.subscription.SubscriptionStore;
import java.util.Map;

public class Services {
    private static final String NO_ACCESS_MESSAGE = "Static class Services cannot be called from a thread \"%s\" which does not have a HiveMQ extension classloader as its context classloader.";
    @Nullable
    private static Map<String, Object> services;

    @NotNull
    public static InitializerRegistry initializerRegistry() {
        return Services.getClassObject(InitializerRegistry.class);
    }

    @NotNull
    public static SecurityRegistry securityRegistry() {
        return Services.getClassObject(SecurityRegistry.class);
    }

    @NotNull
    public static ManagedExtensionExecutorService extensionExecutorService() {
        return Services.getClassObject(ManagedExtensionExecutorService.class);
    }

    @NotNull
    public static SubscriptionStore subscriptionStore() {
        return Services.getClassObject(SubscriptionStore.class);
    }

    @NotNull
    public static PublishService publishService() {
        return Services.getClassObject(PublishService.class);
    }

    @NotNull
    public static ClusterService clusterService() {
        return Services.getClassObject(ClusterService.class);
    }

    @NotNull
    public static RetainedMessageStore retainedMessageStore() {
        return Services.getClassObject(RetainedMessageStore.class);
    }

    @NotNull
    public static MetricRegistry metricRegistry() {
        return Services.getClassObject(MetricRegistry.class);
    }

    @NotNull
    public static EventRegistry eventRegistry() {
        return Services.getClassObject(EventRegistry.class);
    }

    @NotNull
    public static ClientService clientService() {
        return Services.getClassObject(ClientService.class);
    }

    @NotNull
    private static <T> T getClassObject(@NotNull Class<T> clazz) {
        if (services == null) {
            throw new RuntimeException(String.format(NO_ACCESS_MESSAGE, Thread.currentThread().getName()));
        }
        Object object = services.get(clazz.getCanonicalName());
        if (object == null) {
            throw new RuntimeException(String.format(NO_ACCESS_MESSAGE, Thread.currentThread().getName()));
        }
        if (clazz.isInstance(object)) {
            return (T)object;
        }
        throw new RuntimeException(String.format(NO_ACCESS_MESSAGE, Thread.currentThread().getName()));
    }
}

