/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.extension.sdk.api.services.builder;

import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.extension.sdk.api.annotations.Nullable;
import com.hivemq.extension.sdk.api.services.builder.PublishBuilder;
import com.hivemq.extension.sdk.api.services.builder.RetainedPublishBuilder;
import com.hivemq.extension.sdk.api.services.builder.TopicPermissionBuilder;
import com.hivemq.extension.sdk.api.services.builder.TopicSubscriptionBuilder;
import com.hivemq.extension.sdk.api.services.builder.WillPublishBuilder;
import java.util.Map;
import java.util.function.Supplier;

public class Builders {
    private static final String NO_ACCESS_MESSAGE = "Static class Builders cannot be called from a thread \"%s\" which does not have a HiveMQ extension classloader as its context classloader.";
    @Nullable
    private static Map<String, Supplier<Object>> builders;

    @NotNull
    public static RetainedPublishBuilder retainedPublish() {
        return Builders.getClassSupplier(RetainedPublishBuilder.class).get();
    }

    @NotNull
    public static PublishBuilder publish() {
        return Builders.getClassSupplier(PublishBuilder.class).get();
    }

    @NotNull
    public static TopicPermissionBuilder topicPermission() {
        return Builders.getClassSupplier(TopicPermissionBuilder.class).get();
    }

    @NotNull
    public static TopicSubscriptionBuilder topicSubscription() {
        return Builders.getClassSupplier(TopicSubscriptionBuilder.class).get();
    }

    @NotNull
    public static WillPublishBuilder willPublish() {
        return Builders.getClassSupplier(WillPublishBuilder.class).get();
    }

    @NotNull
    private static <T> Supplier<T> getClassSupplier(@NotNull Class<T> clazz) {
        if (builders == null) {
            throw new RuntimeException(String.format(NO_ACCESS_MESSAGE, Thread.currentThread().getName()));
        }
        Supplier<Object> objectSupplier = builders.get(clazz.getCanonicalName());
        if (objectSupplier == null) {
            throw new RuntimeException(String.format(NO_ACCESS_MESSAGE, Thread.currentThread().getName()));
        }
        return objectSupplier;
    }
}

