/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.extension.sdk.api.services.cluster.parameter;

import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.extension.sdk.api.annotations.Nullable;
import java.util.Objects;

public class ClusterNodeAddress {
    @NotNull
    private final String host;
    private final int port;

    public ClusterNodeAddress(@NotNull String host, int port) {
        Objects.requireNonNull(host, "host must not be null");
        if (port < 0 || port > 65535) {
            throw new IllegalArgumentException("port must be within range [0, 65535]");
        }
        this.host = host;
        this.port = port;
    }

    @NotNull
    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ClusterNodeAddress)) {
            return false;
        }
        ClusterNodeAddress that = (ClusterNodeAddress)o;
        return this.port == that.port && this.host.equals(that.host);
    }

    public int hashCode() {
        return Objects.hash(this.host, this.port);
    }

    @NotNull
    public String toString() {
        return this.host + ":" + this.port;
    }
}

