/*
 * Copyright 2018-present HiveMQ GmbH
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.hivemq.extension.sdk.api.parameter;

import com.hivemq.extension.sdk.api.annotations.DoNotImplement;
import com.hivemq.extension.sdk.api.annotations.Immutable;
import com.hivemq.extension.sdk.api.annotations.NotNull;

import java.io.File;
import java.util.Optional;

/**
 * Detailed information about an extension.
 *
 * @author Christoph Schäbel
 * @since 4.0.0, CE 2019.1
 */
@Immutable
@DoNotImplement
public interface ExtensionInformation {

    /**
     * @return The unique ID of an extension.
     * @since 4.0.0, CE 2019.1
     */
    @NotNull String getId();

    /**
     * @return The version of an extension.
     * @since 4.0.0, CE 2019.1
     */
    @NotNull String getVersion();

    /**
     * @return The human readable name of an extension.
     * @since 4.0.0, CE 2019.1
     */
    @NotNull String getName();

    /**
     * @return The author of an extension, if the extension provides information about the author.
     * @since 4.0.0, CE 2019.1
     */
    @NotNull Optional<String> getAuthor();

    /**
     * @return The extensions installation folder.
     * @since 4.0.0, CE 2019.1
     */
    @NotNull File getExtensionHomeFolder();
}
