/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.client.internal.mqtt.codec.decoder.mqtt3;

import com.hivemq.client.internal.mqtt.codec.decoder.MqttDecoderContext;
import com.hivemq.client.internal.mqtt.codec.decoder.MqttDecoderException;
import com.hivemq.client.internal.mqtt.codec.decoder.MqttMessageDecoder;
import com.hivemq.client.internal.mqtt.codec.decoder.MqttMessageDecoderUtil;
import com.hivemq.client.internal.mqtt.datatypes.MqttTopicImpl;
import com.hivemq.client.internal.mqtt.message.publish.MqttPublish;
import com.hivemq.client.internal.mqtt.message.publish.MqttStatefulPublish;
import com.hivemq.client.internal.mqtt.message.publish.mqtt3.Mqtt3PublishView;
import com.hivemq.client.internal.shaded.io.netty.buffer.ByteBuf;
import com.hivemq.client.internal.shaded.javax.inject.Inject;
import com.hivemq.client.internal.shaded.javax.inject.Singleton;
import com.hivemq.client.internal.shaded.org.jetbrains.annotations.NotNull;
import com.hivemq.client.internal.util.ByteBufferUtil;
import com.hivemq.client.mqtt.datatypes.MqttQos;
import java.nio.ByteBuffer;

@Singleton
public class Mqtt3PublishDecoder
implements MqttMessageDecoder {
    private static final int MIN_REMAINING_LENGTH = 2;

    @Inject
    Mqtt3PublishDecoder() {
    }

    @Override
    @NotNull
    public MqttStatefulPublish decode(int flags, @NotNull ByteBuf in, @NotNull MqttDecoderContext context) throws MqttDecoderException {
        boolean retain;
        boolean dup = (flags & 8) != 0;
        MqttQos qos = MqttMessageDecoderUtil.decodePublishQos(flags, dup);
        boolean bl = retain = (flags & 1) != 0;
        if (in.readableBytes() < 2) {
            throw MqttMessageDecoderUtil.remainingLengthTooShort();
        }
        MqttTopicImpl topic = MqttTopicImpl.decode(in);
        if (topic == null) {
            throw MqttMessageDecoderUtil.malformedTopic();
        }
        int packetIdentifier = MqttMessageDecoderUtil.decodePublishPacketIdentifier(qos, in);
        int payloadLength = in.readableBytes();
        ByteBuffer payload = null;
        if (payloadLength > 0) {
            payload = ByteBufferUtil.allocate(payloadLength, context.useDirectBufferPayload());
            in.readBytes(payload);
            payload.position(0);
        }
        MqttPublish publish = Mqtt3PublishView.delegate(topic, payload, qos, retain);
        return Mqtt3PublishView.statefulDelegate(publish, packetIdentifier, dup);
    }
}

