/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.client.internal.mqtt.datatypes;

import com.hivemq.client.internal.mqtt.datatypes.MqttTopicFilterImplBuilder;
import com.hivemq.client.internal.mqtt.datatypes.MqttTopicImpl;
import com.hivemq.client.internal.shaded.org.jetbrains.annotations.NotNull;
import com.hivemq.client.internal.shaded.org.jetbrains.annotations.Nullable;
import com.hivemq.client.internal.util.Checks;
import com.hivemq.client.mqtt.datatypes.MqttTopicBuilder;
import java.util.function.Function;

public abstract class MqttTopicImplBuilder<B extends MqttTopicImplBuilder<B>> {
    @Nullable
    StringBuilder stringBuilder;

    MqttTopicImplBuilder() {
    }

    MqttTopicImplBuilder(@NotNull MqttTopicImpl topic) {
        this.stringBuilder = new StringBuilder(topic.toString());
    }

    @NotNull
    abstract B self();

    @NotNull
    public B addLevel(@Nullable String topicLevel) {
        Checks.notEmpty(topicLevel, "Topic level");
        if (this.stringBuilder == null) {
            this.stringBuilder = new StringBuilder(topicLevel);
        } else {
            this.stringBuilder.append('/').append(topicLevel);
        }
        return this.self();
    }

    @NotNull
    public MqttTopicImpl build() {
        Checks.state(this.stringBuilder != null, "At least one topic level must be added.");
        String string = this.stringBuilder.toString();
        Checks.state(!string.isEmpty(), "Topic must be at least one character long.");
        return MqttTopicImpl.of(string);
    }

    public static class Nested<P>
    extends MqttTopicImplBuilder<Nested<P>>
    implements MqttTopicBuilder.Nested.Complete<P> {
        @NotNull
        private final Function<? super MqttTopicImpl, P> parentConsumer;

        public Nested(@NotNull Function<? super MqttTopicImpl, P> parentConsumer) {
            this.parentConsumer = parentConsumer;
        }

        @Override
        @NotNull
        Nested<P> self() {
            return this;
        }

        @Override
        @NotNull
        public P applyTopic() {
            return this.parentConsumer.apply(this.build());
        }
    }

    public static class Default
    extends MqttTopicImplBuilder<Default>
    implements MqttTopicBuilder.Complete {
        public Default() {
        }

        Default(@NotNull MqttTopicImpl topic) {
            super(topic);
        }

        @Override
        @NotNull
        Default self() {
            return this;
        }

        @Override
        public @NotNull MqttTopicFilterImplBuilder.Default filter() {
            if (this.stringBuilder == null) {
                return new MqttTopicFilterImplBuilder.Default();
            }
            return new MqttTopicFilterImplBuilder.Default(this.stringBuilder.toString());
        }

        @Override
        public @NotNull MqttTopicFilterImplBuilder.SharedDefault share(@Nullable String shareName) {
            if (this.stringBuilder == null) {
                return new MqttTopicFilterImplBuilder.SharedDefault(shareName);
            }
            return new MqttTopicFilterImplBuilder.SharedDefault(shareName, this.stringBuilder.toString());
        }
    }
}

