/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.client.internal.mqtt.handler.connect;

import com.hivemq.client.internal.logging.InternalLogger;
import com.hivemq.client.internal.logging.InternalLoggerFactory;
import com.hivemq.client.internal.mqtt.MqttClientConfig;
import com.hivemq.client.internal.mqtt.MqttClientConnectionConfig;
import com.hivemq.client.internal.mqtt.codec.decoder.MqttDecoder;
import com.hivemq.client.internal.mqtt.codec.encoder.MqttEncoder;
import com.hivemq.client.internal.mqtt.datatypes.MqttClientIdentifierImpl;
import com.hivemq.client.internal.mqtt.handler.MqttSession;
import com.hivemq.client.internal.mqtt.handler.connect.MqttConnAckFlow;
import com.hivemq.client.internal.mqtt.handler.connect.MqttConnAckSingle;
import com.hivemq.client.internal.mqtt.handler.disconnect.MqttDisconnectEvent;
import com.hivemq.client.internal.mqtt.handler.disconnect.MqttDisconnectUtil;
import com.hivemq.client.internal.mqtt.handler.ping.MqttPingHandler;
import com.hivemq.client.internal.mqtt.handler.util.MqttTimeoutInboundHandler;
import com.hivemq.client.internal.mqtt.ioc.ConnectionScope;
import com.hivemq.client.internal.mqtt.lifecycle.MqttClientConnectedContextImpl;
import com.hivemq.client.internal.mqtt.message.MqttMessage;
import com.hivemq.client.internal.mqtt.message.connect.MqttConnect;
import com.hivemq.client.internal.mqtt.message.connect.MqttConnectRestrictions;
import com.hivemq.client.internal.mqtt.message.connect.connack.MqttConnAck;
import com.hivemq.client.internal.mqtt.message.connect.connack.MqttConnAckRestrictions;
import com.hivemq.client.internal.shaded.io.netty.channel.Channel;
import com.hivemq.client.internal.shaded.io.netty.channel.ChannelHandlerContext;
import com.hivemq.client.internal.shaded.javax.inject.Inject;
import com.hivemq.client.internal.shaded.org.jetbrains.annotations.NotNull;
import com.hivemq.client.mqtt.MqttClientState;
import com.hivemq.client.mqtt.MqttVersion;
import com.hivemq.client.mqtt.lifecycle.MqttClientConnectedContext;
import com.hivemq.client.mqtt.lifecycle.MqttClientConnectedListener;
import com.hivemq.client.mqtt.lifecycle.MqttDisconnectSource;
import com.hivemq.client.mqtt.mqtt5.exceptions.Mqtt5ConnAckException;
import com.hivemq.client.mqtt.mqtt5.message.connect.connack.Mqtt5ConnAckReasonCode;
import com.hivemq.client.mqtt.mqtt5.message.disconnect.Mqtt5DisconnectReasonCode;
import java.util.List;

@ConnectionScope
public class MqttConnectHandler
extends MqttTimeoutInboundHandler {
    @NotNull
    public static final String NAME = "connect";
    @NotNull
    private static final InternalLogger LOGGER = InternalLoggerFactory.getLogger(MqttConnectHandler.class);
    @NotNull
    private final MqttConnect connect;
    @NotNull
    private final MqttConnAckFlow connAckFlow;
    @NotNull
    private final MqttClientConfig clientConfig;
    @NotNull
    private final MqttSession session;
    @NotNull
    private final MqttDecoder decoder;
    private boolean connectWritten = false;
    private long connectFlushTime;

    @Inject
    MqttConnectHandler(@NotNull MqttConnect connect, @NotNull MqttConnAckFlow connAckFlow, @NotNull MqttClientConfig clientConfig, @NotNull MqttSession session, @NotNull MqttDecoder decoder) {
        this.connect = connect;
        this.connAckFlow = connAckFlow;
        this.clientConfig = clientConfig;
        this.session = session;
        this.decoder = decoder;
    }

    @Override
    public void handlerAdded(@NotNull ChannelHandlerContext ctx) {
        super.handlerAdded(ctx);
        if (ctx.channel().isActive()) {
            this.writeConnect(ctx);
        }
    }

    @Override
    public void channelActive(@NotNull ChannelHandlerContext ctx) {
        this.writeConnect(ctx);
        ctx.fireChannelActive();
    }

    private void writeConnect(@NotNull ChannelHandlerContext ctx) {
        if (!this.connectWritten) {
            this.connectWritten = true;
            this.connectFlushTime = System.nanoTime();
            ctx.writeAndFlush(this.connect.getRawEnhancedAuthMechanism() == null ? this.connect.createStateful(this.clientConfig.getRawClientIdentifier(), null) : this.connect).addListener(this);
        }
    }

    @Override
    protected void operationSuccessful(@NotNull ChannelHandlerContext ctx) {
        if (this.connect.getRawEnhancedAuthMechanism() == null) {
            this.scheduleTimeout(ctx.channel());
        }
        ctx.pipeline().addAfter("encoder", "decoder", this.decoder);
    }

    @Override
    public void channelRead(@NotNull ChannelHandlerContext ctx, @NotNull Object msg) {
        this.cancelTimeout();
        if (msg instanceof MqttConnAck) {
            this.readConnAck((MqttConnAck)msg, ctx.channel());
        } else {
            this.readOtherThanConnAck(msg, ctx.channel());
        }
    }

    private void readConnAck(@NotNull MqttConnAck connAck, @NotNull Channel channel) {
        if (((Mqtt5ConnAckReasonCode)connAck.getReasonCode()).isError()) {
            MqttDisconnectUtil.fireDisconnectEvent(channel, new Mqtt5ConnAckException(connAck, "CONNECT failed as CONNACK contained an Error Code: " + connAck.getReasonCode() + "."), MqttDisconnectSource.SERVER);
        } else if (this.validateClientIdentifier(connAck, channel)) {
            MqttClientConnectionConfig connectionConfig = this.addConnectionConfig(connAck, channel);
            channel.pipeline().remove(this);
            ((MqttEncoder)channel.pipeline().get("encoder")).onConnected(connectionConfig);
            this.session.startOrResume(connAck, connectionConfig, channel.pipeline(), channel.eventLoop());
            int keepAlive = connectionConfig.getKeepAlive();
            if (keepAlive > 0) {
                MqttPingHandler pingHandler = new MqttPingHandler(keepAlive, this.connectFlushTime, System.nanoTime());
                channel.pipeline().addAfter("decoder", "ping", pingHandler);
            }
            this.clientConfig.getRawState().set(MqttClientState.CONNECTED);
            List connectedListeners = this.clientConfig.getConnectedListeners();
            if (!connectedListeners.isEmpty()) {
                MqttClientConnectedContext context = MqttClientConnectedContextImpl.of(this.clientConfig, this.connect, connAck);
                for (MqttClientConnectedListener connectedListener : connectedListeners) {
                    try {
                        connectedListener.onConnected(context);
                    }
                    catch (Throwable t) {
                        LOGGER.error("Unexpected exception thrown by connected listener.", t);
                    }
                }
            }
            this.connAckFlow.onSuccess(connAck);
        }
    }

    private void readOtherThanConnAck(@NotNull Object msg, @NotNull Channel channel) {
        if (msg instanceof MqttMessage) {
            MqttDisconnectUtil.disconnect(channel, Mqtt5DisconnectReasonCode.PROTOCOL_ERROR, (Object)((Object)((MqttMessage)msg).getType()) + " message must not be received before CONNACK");
        } else {
            MqttDisconnectUtil.close(channel, "No data must be received before CONNECT is sent");
        }
    }

    private boolean validateClientIdentifier(@NotNull MqttConnAck connAck, @NotNull Channel channel) {
        MqttClientIdentifierImpl clientIdentifier = this.clientConfig.getRawClientIdentifier();
        MqttClientIdentifierImpl assignedClientIdentifier = connAck.getRawAssignedClientIdentifier();
        if (clientIdentifier == MqttClientIdentifierImpl.REQUEST_CLIENT_IDENTIFIER_FROM_SERVER) {
            if (this.clientConfig.getMqttVersion() == MqttVersion.MQTT_5_0 && assignedClientIdentifier == null) {
                MqttDisconnectUtil.disconnect(channel, Mqtt5DisconnectReasonCode.PROTOCOL_ERROR, new Mqtt5ConnAckException(connAck, "Server did not assign a Client Identifier"));
                return false;
            }
        } else if (assignedClientIdentifier != null) {
            LOGGER.warn("Server overwrote the Client Identifier {} with {}", clientIdentifier, assignedClientIdentifier);
        }
        if (assignedClientIdentifier != null) {
            this.clientConfig.setClientIdentifier(assignedClientIdentifier);
        }
        return true;
    }

    @NotNull
    private MqttClientConnectionConfig addConnectionConfig(@NotNull MqttConnAck connAck, @NotNull Channel channel) {
        long sessionExpiryInterval;
        int keepAlive = connAck.getRawServerKeepAlive();
        if (keepAlive == -1) {
            keepAlive = this.connect.getKeepAlive();
        }
        if ((sessionExpiryInterval = connAck.getRawSessionExpiryInterval()) == -1L) {
            sessionExpiryInterval = this.connect.getSessionExpiryInterval();
        }
        MqttConnectRestrictions restrictions = this.connect.getRestrictions();
        MqttConnAckRestrictions connAckRestrictions = connAck.getRestrictions();
        MqttClientConnectionConfig connectionConfig = new MqttClientConnectionConfig(this.clientConfig.getCurrentTransportConfig(), keepAlive, this.connect.isCleanStart(), this.connect.getSessionExpiryInterval() == 0L, sessionExpiryInterval, this.connect.getRawSimpleAuth() != null, this.connect.getRawWillPublish() != null, this.connect.getRawEnhancedAuthMechanism(), restrictions.getReceiveMaximum(), restrictions.getMaximumPacketSize(), restrictions.getTopicAliasMaximum(), restrictions.isRequestProblemInformation(), restrictions.isRequestResponseInformation(), Math.min(restrictions.getSendMaximum(), connAckRestrictions.getReceiveMaximum()), Math.min(restrictions.getSendMaximumPacketSize(), connAckRestrictions.getMaximumPacketSize()), Math.min(restrictions.getSendTopicAliasMaximum(), connAckRestrictions.getTopicAliasMaximum()), connAckRestrictions.getMaximumQos(), connAckRestrictions.isRetainAvailable(), connAckRestrictions.isWildcardSubscriptionAvailable(), connAckRestrictions.isSharedSubscriptionAvailable(), connAckRestrictions.areSubscriptionIdentifiersAvailable(), channel);
        this.clientConfig.setConnectionConfig(connectionConfig);
        return connectionConfig;
    }

    @Override
    protected void onDisconnectEvent(@NotNull ChannelHandlerContext ctx, @NotNull MqttDisconnectEvent disconnectEvent) {
        super.onDisconnectEvent(ctx, disconnectEvent);
        MqttConnAckSingle.reconnect(this.clientConfig, disconnectEvent.getSource(), disconnectEvent.getCause(), this.connect, this.connAckFlow, ctx.channel().eventLoop());
    }

    @Override
    protected long getTimeoutMs() {
        return this.clientConfig.getCurrentTransportConfig().getMqttConnectTimeoutMs();
    }

    @Override
    @NotNull
    protected Mqtt5DisconnectReasonCode getTimeoutReasonCode() {
        return Mqtt5DisconnectReasonCode.PROTOCOL_ERROR;
    }

    @Override
    @NotNull
    protected String getTimeoutReasonString() {
        return "Timeout while waiting for CONNACK";
    }
}

