/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.client.internal.mqtt.handler.proxy;

import com.hivemq.client.internal.mqtt.MqttProxyConfigImpl;
import com.hivemq.client.internal.shaded.io.netty.channel.Channel;
import com.hivemq.client.internal.shaded.io.netty.channel.ChannelDuplexHandler;
import com.hivemq.client.internal.shaded.io.netty.channel.ChannelHandler;
import com.hivemq.client.internal.shaded.io.netty.channel.ChannelHandlerContext;
import com.hivemq.client.internal.shaded.io.netty.channel.ChannelPipeline;
import com.hivemq.client.internal.shaded.io.netty.channel.ChannelPromise;
import com.hivemq.client.internal.shaded.io.netty.handler.proxy.HttpProxyHandler;
import com.hivemq.client.internal.shaded.io.netty.handler.proxy.ProxyHandler;
import com.hivemq.client.internal.shaded.io.netty.handler.proxy.Socks4ProxyHandler;
import com.hivemq.client.internal.shaded.io.netty.handler.proxy.Socks5ProxyHandler;
import com.hivemq.client.internal.shaded.io.netty.util.concurrent.Future;
import com.hivemq.client.internal.shaded.io.netty.util.concurrent.FutureListener;
import com.hivemq.client.internal.shaded.org.jetbrains.annotations.NotNull;
import com.hivemq.client.internal.shaded.org.jetbrains.annotations.Nullable;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.NoSuchElementException;
import java.util.function.BiConsumer;
import java.util.function.Consumer;

class MqttProxyAdapterHandler
extends ChannelDuplexHandler
implements FutureListener<Channel> {
    @NotNull
    public static final String NAME = "proxy.adapter";
    @NotNull
    private static final String PROXY_HANDLER_NAME = "proxy";
    @NotNull
    private final MqttProxyConfigImpl proxyConfig;
    @NotNull
    private final InetSocketAddress serverAddress;
    @NotNull
    private final Consumer<Channel> onSuccess;
    @NotNull
    private final BiConsumer<Channel, Throwable> onError;
    private boolean handshakeDone = false;

    public MqttProxyAdapterHandler(@NotNull MqttProxyConfigImpl proxyConfig, @NotNull InetSocketAddress serverAddress, @NotNull Consumer<Channel> onSuccess, @NotNull BiConsumer<Channel, Throwable> onError) {
        this.proxyConfig = proxyConfig;
        this.serverAddress = serverAddress;
        this.onSuccess = onSuccess;
        this.onError = onError;
    }

    @Override
    public void connect(@NotNull ChannelHandlerContext ctx, @NotNull SocketAddress remoteAddress, @Nullable SocketAddress localAddress, @NotNull ChannelPromise promise) {
        ProxyHandler proxyHandler;
        Channel channel = ctx.channel();
        String username = this.proxyConfig.getRawUsername();
        String password = this.proxyConfig.getRawPassword();
        switch (this.proxyConfig.getProtocol()) {
            case SOCKS_4: {
                proxyHandler = new Socks4ProxyHandler(remoteAddress, username);
                break;
            }
            case SOCKS_5: {
                proxyHandler = new Socks5ProxyHandler(remoteAddress, username, password);
                break;
            }
            case HTTP: {
                if (username == null && password == null) {
                    proxyHandler = new HttpProxyHandler(remoteAddress);
                    break;
                }
                proxyHandler = new HttpProxyHandler(remoteAddress, username == null ? "" : username, password == null ? "" : password);
                break;
            }
            default: {
                if (this.setHandshakeDone(channel.pipeline())) {
                    this.onError.accept(channel, new IllegalStateException("Unknown proxy protocol " + (Object)((Object)this.proxyConfig.getProtocol())));
                }
                return;
            }
        }
        proxyHandler.setConnectTimeoutMillis(this.proxyConfig.getHandshakeTimeoutMs());
        proxyHandler.connectFuture().addListener(this);
        channel.pipeline().addFirst(PROXY_HANDLER_NAME, (ChannelHandler)proxyHandler);
        ctx.connect(this.serverAddress, localAddress, promise);
    }

    @Override
    public void operationComplete(@NotNull Future<Channel> future) {
        Channel channel;
        if (future.isSuccess() && this.setHandshakeDone((channel = future.getNow()).pipeline())) {
            this.onSuccess.accept(channel);
        }
    }

    @Override
    public void exceptionCaught(@NotNull ChannelHandlerContext ctx, @NotNull Throwable cause) {
        if (this.setHandshakeDone(ctx.pipeline())) {
            this.onError.accept(ctx.channel(), cause);
        } else {
            ctx.fireExceptionCaught(cause);
        }
    }

    private boolean setHandshakeDone(@NotNull ChannelPipeline pipeline) {
        if (!this.handshakeDone) {
            this.handshakeDone = true;
            pipeline.remove(this);
            try {
                pipeline.remove(PROXY_HANDLER_NAME);
            }
            catch (NoSuchElementException noSuchElementException) {
                // empty catch block
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean isSharable() {
        return false;
    }
}

