/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.client.internal.mqtt.handler.publish.outgoing;

import com.hivemq.client.internal.mqtt.MqttClientConfig;
import com.hivemq.client.internal.mqtt.exceptions.MqttClientStateExceptions;
import com.hivemq.client.internal.mqtt.handler.publish.outgoing.MqttAckFlowableFlow;
import com.hivemq.client.internal.mqtt.handler.publish.outgoing.MqttOutgoingQosHandler;
import com.hivemq.client.internal.mqtt.handler.publish.outgoing.MqttPublishFlowableAckLink;
import com.hivemq.client.internal.mqtt.handler.publish.outgoing.MqttPublishFlowables;
import com.hivemq.client.internal.mqtt.ioc.ClientComponent;
import com.hivemq.client.internal.mqtt.message.publish.MqttPublish;
import com.hivemq.client.internal.shaded.org.jetbrains.annotations.NotNull;
import com.hivemq.client.mqtt.mqtt5.message.publish.Mqtt5PublishResult;
import io.reactivex.Flowable;
import io.reactivex.internal.subscriptions.EmptySubscription;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public class MqttAckFlowable
extends Flowable<Mqtt5PublishResult> {
    @NotNull
    private final MqttClientConfig clientConfig;
    @NotNull
    private final Flowable<MqttPublish> publishFlowable;

    public MqttAckFlowable(@NotNull MqttClientConfig clientConfig, @NotNull Flowable<MqttPublish> publishFlowable) {
        this.clientConfig = clientConfig;
        this.publishFlowable = publishFlowable;
    }

    protected void subscribeActual(@NotNull Subscriber<? super Mqtt5PublishResult> subscriber) {
        if (this.clientConfig.getState().isConnectedOrReconnect()) {
            ClientComponent clientComponent = this.clientConfig.getClientComponent();
            MqttOutgoingQosHandler outgoingQosHandler = clientComponent.outgoingQosHandler();
            MqttPublishFlowables publishFlowables = outgoingQosHandler.getPublishFlowables();
            MqttAckFlowableFlow flow = new MqttAckFlowableFlow(subscriber, this.clientConfig, outgoingQosHandler);
            subscriber.onSubscribe((Subscription)flow);
            publishFlowables.add(new MqttPublishFlowableAckLink(this.publishFlowable, flow));
        } else {
            EmptySubscription.error((Throwable)MqttClientStateExceptions.notConnected(), subscriber);
        }
    }
}

