/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.client.internal.mqtt.handler.publish.outgoing;

import com.hivemq.client.internal.mqtt.datatypes.MqttTopicImpl;
import com.hivemq.client.internal.mqtt.handler.publish.outgoing.MqttTopicAliasMapping;
import com.hivemq.client.internal.shaded.org.jetbrains.annotations.NotNull;
import com.hivemq.client.internal.shaded.org.jetbrains.annotations.Nullable;
import com.hivemq.client.internal.util.collections.Index;

public class MqttTopicAliasAutoMapping
implements MqttTopicAliasMapping {
    private static final byte OVERSIZE = 4;
    private static final byte RETAIN = 8;
    private static final byte OVERWRITE_COST_MIN = 2;
    private static final byte OVERWRITE_COST_MAX = 126;
    private static final byte OVERWRITE_COST_INC = 2;
    private static final @NotNull Index.Spec<Entry, String> INDEX_SPEC = new Index.Spec<Entry, String>(entry -> entry.topic);
    private final int topicAliasMaximum;
    @NotNull
    private final Index<Entry, String> map = new Index<Entry, String>(INDEX_SPEC);
    @Nullable
    private Entry lowest;
    private long accessCounter;
    private byte overwriteTries;
    private byte overwriteCost = (byte)2;
    private byte fullOverwriteTries;
    private byte fullOverwriteCost = (byte)2;

    public MqttTopicAliasAutoMapping(int topicAliasMaximum) {
        this.topicAliasMaximum = topicAliasMaximum;
    }

    @Override
    public int getTopicAliasMaximum() {
        return this.topicAliasMaximum;
    }

    @Override
    public int onPublish(@NotNull MqttTopicImpl topic) {
        long accessCounter = ++this.accessCounter;
        String topicString = topic.toString();
        Entry entry = this.map.get(topicString);
        if (entry != null) {
            entry.access(accessCounter);
            if (entry.topicAlias != 0) {
                if (this.overwriteCost > 2) {
                    this.overwriteCost = (byte)(this.overwriteCost - 1);
                }
                if (this.fullOverwriteCost > 2) {
                    this.fullOverwriteCost = (byte)(this.fullOverwriteCost - 1);
                }
                if (entry.lower != null) {
                    if (entry.lower.topicAlias == 0) {
                        this.overwriteTries = 0;
                    }
                } else {
                    this.fullOverwriteTries = 0;
                }
            }
            this.swapNewer(entry, accessCounter);
            return entry.topicAlias;
        }
        Entry newEntry = new Entry(topicString, accessCounter);
        if (this.map.size() < this.topicAliasMaximum + 4) {
            if (this.map.size() < this.topicAliasMaximum) {
                newEntry.setNewTopicAlias(this.map.size() + 1);
            }
            this.map.put(newEntry);
            if (this.lowest != null) {
                newEntry.higher = this.lowest;
                this.lowest.lower = newEntry;
            }
        } else {
            Entry higher;
            Entry lowest = this.lowest;
            assert (lowest != null);
            if (newEntry.priority(accessCounter) <= lowest.priority(accessCounter)) {
                return 0;
            }
            this.fullOverwriteTries = (byte)(this.fullOverwriteTries + 1);
            if (this.fullOverwriteTries < this.fullOverwriteCost) {
                return 0;
            }
            this.fullOverwriteTries = 0;
            if (this.fullOverwriteCost < 126) {
                this.fullOverwriteCost = (byte)(this.fullOverwriteCost + (byte)Math.min(2, 126 - this.fullOverwriteCost));
            }
            if (lowest.topicAlias != 0) {
                newEntry.setNewTopicAlias(lowest.topicAlias);
            }
            this.map.remove(lowest.topic);
            this.map.put(newEntry);
            newEntry.higher = higher = lowest.higher;
            if (higher != null) {
                higher.lower = newEntry;
            }
        }
        this.lowest = newEntry;
        this.swapNewer(newEntry, accessCounter);
        return newEntry.topicAlias;
    }

    private void swapNewer(@NotNull Entry entry, long accessCounter) {
        long newerPriority;
        Entry higher = entry.higher;
        if (entry.higher == null) {
            return;
        }
        Entry lower = entry.lower;
        long priority = entry.priority(accessCounter);
        while ((newerPriority = higher.priority(accessCounter)) < priority) {
            if (entry.topicAlias == 0 && higher.topicAlias != 0) {
                this.overwriteTries = (byte)(this.overwriteTries + 1);
                if (this.overwriteTries < this.overwriteCost) break;
                this.overwriteTries = 0;
                if (this.overwriteCost < 126) {
                    this.overwriteCost = (byte)(this.overwriteCost + (byte)Math.min(2, 126 - this.overwriteCost));
                }
                entry.setNewTopicAlias(higher.topicAlias);
                higher.topicAlias = 0;
            }
            Entry higherHigher = higher.higher;
            higher.higher = entry;
            entry.lower = higher;
            if (lower == null) {
                higher.lower = null;
                this.lowest = higher;
            } else {
                lower.higher = higher;
                higher.lower = lower;
            }
            if (higherHigher == null) {
                entry.higher = null;
                break;
            }
            entry.higher = higherHigher;
            higherHigher.lower = entry;
            lower = higher;
            higher = higherHigher;
        }
    }

    @NotNull
    public String toString() {
        StringBuilder builder = new StringBuilder("{");
        Entry entry = this.lowest;
        while (entry != null) {
            builder.append("\n  ").append(entry);
            entry = entry.higher;
        }
        return builder.append("\n}").toString();
    }

    static class Entry {
        @NotNull
        final String topic;
        int topicAlias;
        private long used;
        private long access;
        @Nullable
        Entry higher;
        @Nullable
        Entry lower;

        Entry(@NotNull String topic, long accessCounter) {
            this.topic = topic;
            this.topicAlias = 0;
            this.used = 1L;
            this.access = accessCounter;
        }

        void setNewTopicAlias(int topicAlias) {
            this.topicAlias = topicAlias | 0x10000;
        }

        void access(long accessCounter) {
            this.topicAlias &= 0xFFFF;
            this.used = this.priority(accessCounter) + 1L;
            this.access = accessCounter;
        }

        long priority(long accessCounter) {
            long decay = Math.max(accessCounter - this.access - 8L, 0L);
            return Math.max(this.used - decay, 0L);
        }

        @NotNull
        public String toString() {
            return "{topic='" + this.topic + '\'' + (this.topicAlias == 0 ? "" : ", alias=" + (this.topicAlias & 0xFFFF)) + ((this.topicAlias & 0x10000) == 0 ? "" : ", new ") + ", used = " + this.used + ", access = " + this.access + '}';
        }
    }
}

