/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.client.internal.mqtt.handler.ssl;

import com.hivemq.client.internal.shaded.io.netty.channel.Channel;
import com.hivemq.client.internal.shaded.io.netty.channel.ChannelHandlerContext;
import com.hivemq.client.internal.shaded.io.netty.channel.ChannelInboundHandlerAdapter;
import com.hivemq.client.internal.shaded.io.netty.handler.ssl.SslHandler;
import com.hivemq.client.internal.shaded.io.netty.handler.ssl.SslHandshakeCompletionEvent;
import com.hivemq.client.internal.shaded.org.jetbrains.annotations.NotNull;
import com.hivemq.client.internal.shaded.org.jetbrains.annotations.Nullable;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLHandshakeException;

class MqttSslAdapterHandler
extends ChannelInboundHandlerAdapter {
    @NotNull
    public static final String NAME = "ssl.adapter";
    @NotNull
    private final SslHandler sslHandler;
    @NotNull
    private final String host;
    @Nullable
    private final HostnameVerifier hostnameVerifier;
    @NotNull
    private final Consumer<Channel> onSuccess;
    @NotNull
    private final BiConsumer<Channel, Throwable> onError;
    private boolean handshakeDone = false;

    public MqttSslAdapterHandler(@NotNull SslHandler sslHandler, @NotNull String host, @Nullable HostnameVerifier hostnameVerifier, @NotNull Consumer<Channel> onSuccess, @NotNull BiConsumer<Channel, Throwable> onError) {
        this.sslHandler = sslHandler;
        this.host = host;
        this.hostnameVerifier = hostnameVerifier;
        this.onSuccess = onSuccess;
        this.onError = onError;
    }

    @Override
    public void userEventTriggered(@NotNull ChannelHandlerContext ctx, @NotNull Object evt) {
        if (evt instanceof SslHandshakeCompletionEvent) {
            this.handshakeComplete(ctx, (SslHandshakeCompletionEvent)evt);
        } else {
            ctx.fireUserEventTriggered(evt);
        }
    }

    private void handshakeComplete(@NotNull ChannelHandlerContext ctx, @NotNull SslHandshakeCompletionEvent evt) {
        if (this.setHandshakeDone()) {
            if (evt.isSuccess()) {
                ctx.pipeline().remove(this);
                if (this.hostnameVerifier == null || this.hostnameVerifier.verify(this.host, this.sslHandler.engine().getSession())) {
                    this.onSuccess.accept(ctx.channel());
                } else {
                    this.onError.accept(ctx.channel(), new SSLHandshakeException("Hostname verification failed"));
                }
            } else {
                this.onError.accept(ctx.channel(), evt.cause());
            }
        }
    }

    @Override
    public void exceptionCaught(@NotNull ChannelHandlerContext ctx, @NotNull Throwable cause) {
        ctx.pipeline().remove(this);
        if (this.setHandshakeDone()) {
            this.onError.accept(ctx.channel(), cause);
        }
    }

    private boolean setHandshakeDone() {
        if (!this.handshakeDone) {
            this.handshakeDone = true;
            return true;
        }
        return false;
    }

    @Override
    public boolean isSharable() {
        return false;
    }
}

