/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.client.internal.mqtt.handler.websocket;

import com.hivemq.client.internal.shaded.io.netty.channel.Channel;
import com.hivemq.client.internal.shaded.io.netty.channel.ChannelHandlerContext;
import com.hivemq.client.internal.shaded.io.netty.channel.ChannelInboundHandlerAdapter;
import com.hivemq.client.internal.shaded.io.netty.handler.codec.http.FullHttpResponse;
import com.hivemq.client.internal.shaded.io.netty.handler.codec.http.websocketx.WebSocketClientHandshaker;
import com.hivemq.client.internal.shaded.io.netty.handler.codec.http.websocketx.WebSocketHandshakeException;
import com.hivemq.client.internal.shaded.io.netty.util.concurrent.ScheduledFuture;
import com.hivemq.client.internal.shaded.org.jetbrains.annotations.NotNull;
import com.hivemq.client.internal.shaded.org.jetbrains.annotations.Nullable;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.function.Consumer;

class MqttWebsocketHandshakeHandler
extends ChannelInboundHandlerAdapter {
    @NotNull
    public static final String NAME = "ws.handshake";
    @NotNull
    private final WebSocketClientHandshaker handshaker;
    private final int handshakeTimeoutMs;
    @NotNull
    private final Consumer<Channel> onSuccess;
    @NotNull
    private final BiConsumer<Channel, Throwable> onError;
    private boolean handshakeStarted = false;
    private boolean handshakeDone = false;
    @Nullable
    private ScheduledFuture<?> timeoutFuture;

    MqttWebsocketHandshakeHandler(@NotNull WebSocketClientHandshaker handshaker, int handshakeTimeoutMs, @NotNull Consumer<Channel> onSuccess, @NotNull BiConsumer<Channel, Throwable> onError) {
        this.handshaker = handshaker;
        this.handshakeTimeoutMs = handshakeTimeoutMs;
        this.onSuccess = onSuccess;
        this.onError = onError;
    }

    @Override
    public void handlerAdded(@NotNull ChannelHandlerContext ctx) {
        if (ctx.channel().isActive()) {
            this.startHandshake(ctx);
        }
    }

    @Override
    public void channelActive(@NotNull ChannelHandlerContext ctx) {
        this.startHandshake(ctx);
        ctx.fireChannelActive();
    }

    private void startHandshake(@NotNull ChannelHandlerContext ctx) {
        if (!this.handshakeStarted) {
            this.handshakeStarted = true;
            if (this.handshakeTimeoutMs > 0) {
                this.timeoutFuture = ctx.channel().eventLoop().schedule(() -> {
                    if (this.setHandshakeDone(ctx)) {
                        this.onError.accept(ctx.channel(), new WebSocketHandshakeException("handshake timed out after " + this.handshakeTimeoutMs + "ms"));
                    }
                }, (long)this.handshakeTimeoutMs, TimeUnit.MILLISECONDS);
            }
            this.handshaker.handshake(ctx.channel(), ctx.voidPromise());
        }
    }

    @Override
    public void channelRead(@NotNull ChannelHandlerContext ctx, @NotNull Object msg) {
        if (msg instanceof FullHttpResponse) {
            this.finishHandshake(ctx, (FullHttpResponse)msg);
        } else {
            ctx.fireChannelRead(msg);
        }
    }

    private void finishHandshake(@NotNull ChannelHandlerContext ctx, @NotNull FullHttpResponse response) {
        if (this.setHandshakeDone(ctx)) {
            try {
                this.handshaker.finishHandshake(ctx.channel(), response);
                this.onSuccess.accept(ctx.channel());
            }
            catch (Throwable t) {
                this.onError.accept(ctx.channel(), t);
            }
        }
        response.release();
    }

    @Override
    public void channelInactive(@NotNull ChannelHandlerContext ctx) {
        if (this.setHandshakeDone(ctx)) {
            this.onError.accept(ctx.channel(), new WebSocketHandshakeException("connection was closed during handshake"));
        }
        ctx.fireChannelInactive();
    }

    @Override
    public void exceptionCaught(@NotNull ChannelHandlerContext ctx, @NotNull Throwable cause) {
        if (this.setHandshakeDone(ctx)) {
            this.onError.accept(ctx.channel(), cause);
        } else {
            ctx.fireExceptionCaught(cause);
        }
    }

    private boolean setHandshakeDone(@NotNull ChannelHandlerContext ctx) {
        if (!this.handshakeDone) {
            this.handshakeDone = true;
            ctx.pipeline().remove(this);
            if (this.timeoutFuture != null) {
                this.timeoutFuture.cancel(false);
                this.timeoutFuture = null;
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean isSharable() {
        return false;
    }
}

