/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.client.internal.mqtt.ioc;

import com.hivemq.client.internal.mqtt.handler.MqttChannelInitializer;
import com.hivemq.client.internal.mqtt.handler.auth.MqttAuthHandler;
import com.hivemq.client.internal.mqtt.handler.auth.MqttConnectAuthHandler;
import com.hivemq.client.internal.mqtt.handler.auth.MqttDisconnectOnAuthHandler;
import com.hivemq.client.internal.mqtt.ioc.ConnectionScope;
import com.hivemq.client.internal.mqtt.message.connect.MqttConnect;
import com.hivemq.client.internal.netty.NettyEventLoopProvider;
import com.hivemq.client.internal.shaded.dagger.Lazy;
import com.hivemq.client.internal.shaded.dagger.Module;
import com.hivemq.client.internal.shaded.dagger.Provides;
import com.hivemq.client.internal.shaded.io.netty.bootstrap.Bootstrap;
import com.hivemq.client.internal.shaded.org.jetbrains.annotations.NotNull;

@Module
abstract class ConnectionModule {
    ConnectionModule() {
    }

    @Provides
    @NotNull
    static Bootstrap provideBootstrap(@NotNull MqttChannelInitializer channelInitializer) {
        return (Bootstrap)((Bootstrap)new Bootstrap().channelFactory(NettyEventLoopProvider.INSTANCE.getChannelFactory())).handler(channelInitializer);
    }

    @Provides
    @ConnectionScope
    @NotNull
    static MqttAuthHandler provideAuthHandler(@NotNull MqttConnect connect, @NotNull Lazy<MqttConnectAuthHandler> connectAuthHandlerLazy, @NotNull Lazy<MqttDisconnectOnAuthHandler> disconnectOnAuthHandlerLazy) {
        return connect.getRawEnhancedAuthMechanism() == null ? (MqttAuthHandler)disconnectOnAuthHandlerLazy.get() : (MqttAuthHandler)connectAuthHandlerLazy.get();
    }
}

