/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.client.internal.mqtt.message.auth;

import com.hivemq.client.annotations.Immutable;
import com.hivemq.client.internal.mqtt.datatypes.MqttUtf8StringImpl;
import com.hivemq.client.internal.shaded.org.jetbrains.annotations.NotNull;
import com.hivemq.client.internal.shaded.org.jetbrains.annotations.Nullable;
import com.hivemq.client.internal.util.ByteBufferUtil;
import com.hivemq.client.mqtt.mqtt5.message.auth.Mqtt5EnhancedAuth;
import java.nio.ByteBuffer;
import java.util.Objects;
import java.util.Optional;

@Immutable
public class MqttEnhancedAuth
implements Mqtt5EnhancedAuth {
    @NotNull
    private final MqttUtf8StringImpl method;
    @Nullable
    private final ByteBuffer data;

    public MqttEnhancedAuth(@NotNull MqttUtf8StringImpl method, @Nullable ByteBuffer data) {
        this.method = method;
        this.data = data;
    }

    @Override
    @NotNull
    public MqttUtf8StringImpl getMethod() {
        return this.method;
    }

    @Override
    @NotNull
    public Optional<ByteBuffer> getData() {
        return ByteBufferUtil.optionalReadOnly(this.data);
    }

    @Nullable
    public ByteBuffer getRawData() {
        return this.data;
    }

    @NotNull
    private String toAttributeString() {
        return "method=" + this.method + (this.data == null ? "" : ", data=" + this.data.remaining() + "byte");
    }

    @NotNull
    public String toString() {
        return "MqttEnhancedAuth{" + this.toAttributeString() + '}';
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MqttEnhancedAuth)) {
            return false;
        }
        MqttEnhancedAuth that = (MqttEnhancedAuth)o;
        return this.method.equals(that.method) && Objects.equals(this.data, that.data);
    }

    public int hashCode() {
        int result = this.method.hashCode();
        result = 31 * result + Objects.hashCode(this.data);
        return result;
    }
}

