/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.client.internal.mqtt.message.connect.mqtt3;

import com.hivemq.client.internal.mqtt.message.auth.MqttSimpleAuth;
import com.hivemq.client.internal.mqtt.message.auth.mqtt3.Mqtt3SimpleAuthView;
import com.hivemq.client.internal.mqtt.message.auth.mqtt3.Mqtt3SimpleAuthViewBuilder;
import com.hivemq.client.internal.mqtt.message.connect.MqttConnect;
import com.hivemq.client.internal.mqtt.message.connect.MqttConnectRestrictions;
import com.hivemq.client.internal.mqtt.message.connect.MqttConnectRestrictionsBuilder;
import com.hivemq.client.internal.mqtt.message.connect.mqtt3.Mqtt3ConnectView;
import com.hivemq.client.internal.mqtt.message.publish.MqttWillPublish;
import com.hivemq.client.internal.mqtt.message.publish.mqtt3.Mqtt3PublishView;
import com.hivemq.client.internal.mqtt.message.publish.mqtt3.Mqtt3PublishViewBuilder;
import com.hivemq.client.internal.shaded.org.jetbrains.annotations.NotNull;
import com.hivemq.client.internal.shaded.org.jetbrains.annotations.Nullable;
import com.hivemq.client.internal.util.Checks;
import com.hivemq.client.mqtt.mqtt3.message.auth.Mqtt3SimpleAuth;
import com.hivemq.client.mqtt.mqtt3.message.connect.Mqtt3ConnectBuilder;
import com.hivemq.client.mqtt.mqtt3.message.connect.Mqtt3ConnectRestrictions;
import com.hivemq.client.mqtt.mqtt3.message.publish.Mqtt3Publish;
import java.util.function.Function;

public abstract class Mqtt3ConnectViewBuilder<B extends Mqtt3ConnectViewBuilder<B>> {
    private int keepAliveSeconds = 60;
    private boolean cleanSession = true;
    @NotNull
    private MqttConnectRestrictions restrictions = MqttConnectRestrictions.DEFAULT;
    @Nullable
    private MqttSimpleAuth simpleAuth;
    @Nullable
    private MqttWillPublish willPublish;

    Mqtt3ConnectViewBuilder() {
    }

    Mqtt3ConnectViewBuilder(@NotNull Mqtt3ConnectView connect) {
        MqttConnect delegate = connect.getDelegate();
        this.keepAliveSeconds = delegate.getKeepAlive();
        this.cleanSession = delegate.isCleanStart();
        this.restrictions = delegate.getRestrictions();
        this.simpleAuth = delegate.getRawSimpleAuth();
        this.willPublish = delegate.getRawWillPublish();
    }

    @NotNull
    abstract B self();

    @NotNull
    public B keepAlive(int keepAlive) {
        this.keepAliveSeconds = Checks.unsignedShort(keepAlive, "Keep alive");
        return this.self();
    }

    @NotNull
    public B noKeepAlive() {
        this.keepAliveSeconds = 0;
        return this.self();
    }

    @NotNull
    public B cleanSession(boolean cleanSession) {
        this.cleanSession = cleanSession;
        return this.self();
    }

    @NotNull
    public B restrictions(@Nullable Mqtt3ConnectRestrictions restrictions) {
        this.restrictions = Checks.notImplemented(restrictions, MqttConnectRestrictions.class, "Connect restrictions");
        return this.self();
    }

    public @NotNull MqttConnectRestrictionsBuilder.Nested<B> restrictions() {
        return new MqttConnectRestrictionsBuilder.Nested<Mqtt3ConnectViewBuilder>(this.restrictions, this::restrictions);
    }

    @NotNull
    public B simpleAuth(@Nullable Mqtt3SimpleAuth simpleAuth) {
        this.simpleAuth = simpleAuth == null ? null : Checks.notImplemented(simpleAuth, Mqtt3SimpleAuthView.class, "Simple auth").getDelegate();
        return this.self();
    }

    public  @NotNull Mqtt3SimpleAuthViewBuilder.Nested<B> simpleAuth() {
        return new Mqtt3SimpleAuthViewBuilder.Nested<Mqtt3ConnectViewBuilder>(this::simpleAuth);
    }

    @NotNull
    public B willPublish(@Nullable Mqtt3Publish willPublish) {
        this.willPublish = willPublish == null ? null : Checks.notImplemented(willPublish, Mqtt3PublishView.class, "Will publish").getDelegate().asWill();
        return this.self();
    }

    public  @NotNull Mqtt3PublishViewBuilder.WillNested<B> willPublish() {
        return new Mqtt3PublishViewBuilder.WillNested<Mqtt3ConnectViewBuilder>(this::willPublish);
    }

    @NotNull
    public Mqtt3ConnectView build() {
        return Mqtt3ConnectView.of(this.keepAliveSeconds, this.cleanSession, this.restrictions, this.simpleAuth, this.willPublish);
    }

    public static class Send<P>
    extends Mqtt3ConnectViewBuilder<Send<P>>
    implements Mqtt3ConnectBuilder.Send<P> {
        @NotNull
        private final Function<? super Mqtt3ConnectView, P> parentConsumer;

        public Send(@NotNull Function<? super Mqtt3ConnectView, P> parentConsumer) {
            this.parentConsumer = parentConsumer;
        }

        @Override
        @NotNull
        Send<P> self() {
            return this;
        }

        @Override
        @NotNull
        public P send() {
            return this.parentConsumer.apply(this.build());
        }
    }

    public static class Nested<P>
    extends Mqtt3ConnectViewBuilder<Nested<P>>
    implements Mqtt3ConnectBuilder.Nested<P> {
        @NotNull
        private final Function<? super Mqtt3ConnectView, P> parentConsumer;

        public Nested(@NotNull Function<? super Mqtt3ConnectView, P> parentConsumer) {
            this.parentConsumer = parentConsumer;
        }

        public Nested(@NotNull Mqtt3ConnectView connect, @NotNull Function<? super Mqtt3ConnectView, P> parentConsumer) {
            super(connect);
            this.parentConsumer = parentConsumer;
        }

        @Override
        @NotNull
        Nested<P> self() {
            return this;
        }

        @Override
        @NotNull
        public P applyConnect() {
            return this.parentConsumer.apply(this.build());
        }
    }

    public static class Default
    extends Mqtt3ConnectViewBuilder<Default>
    implements Mqtt3ConnectBuilder {
        public Default() {
        }

        Default(@NotNull Mqtt3ConnectView connect) {
            super(connect);
        }

        @Override
        @NotNull
        Default self() {
            return this;
        }
    }
}

