/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.client.internal.mqtt.message.subscribe.mqtt3;

import com.hivemq.client.annotations.Immutable;
import com.hivemq.client.internal.mqtt.datatypes.MqttUserPropertiesImpl;
import com.hivemq.client.internal.mqtt.message.subscribe.MqttSubscribe;
import com.hivemq.client.internal.mqtt.message.subscribe.MqttSubscription;
import com.hivemq.client.internal.mqtt.message.subscribe.mqtt3.Mqtt3SubscribeViewBuilder;
import com.hivemq.client.internal.mqtt.message.subscribe.mqtt3.Mqtt3SubscriptionView;
import com.hivemq.client.internal.shaded.org.jetbrains.annotations.NotNull;
import com.hivemq.client.internal.shaded.org.jetbrains.annotations.Nullable;
import com.hivemq.client.internal.util.collections.ImmutableList;
import com.hivemq.client.mqtt.mqtt3.message.subscribe.Mqtt3Subscribe;
import java.util.List;

@Immutable
public class Mqtt3SubscribeView
implements Mqtt3Subscribe {
    @NotNull
    private final MqttSubscribe delegate;

    @NotNull
    private static MqttSubscribe delegate(@NotNull ImmutableList<MqttSubscription> subscriptions) {
        return new MqttSubscribe(subscriptions, MqttUserPropertiesImpl.NO_USER_PROPERTIES);
    }

    @NotNull
    static Mqtt3SubscribeView of(@NotNull ImmutableList<MqttSubscription> subscriptions) {
        return new Mqtt3SubscribeView(Mqtt3SubscribeView.delegate(subscriptions));
    }

    @NotNull
    public static Mqtt3SubscribeView of(@NotNull MqttSubscribe delegate) {
        return new Mqtt3SubscribeView(delegate);
    }

    private Mqtt3SubscribeView(@NotNull MqttSubscribe delegate) {
        this.delegate = delegate;
    }

    @NotNull
    public ImmutableList<Mqtt3SubscriptionView> getSubscriptions() {
        List subscriptions = this.delegate.getSubscriptions();
        ImmutableList.Builder<Mqtt3SubscriptionView> builder = ImmutableList.builder(subscriptions.size());
        for (int i = 0; i < subscriptions.size(); ++i) {
            builder.add(Mqtt3SubscriptionView.of((MqttSubscription)subscriptions.get(i)));
        }
        return builder.build();
    }

    @NotNull
    public MqttSubscribe getDelegate() {
        return this.delegate;
    }

    @Override
    public @NotNull Mqtt3SubscribeViewBuilder.Default extend() {
        return new Mqtt3SubscribeViewBuilder.Default(this);
    }

    @NotNull
    private String toAttributeString() {
        return "subscriptions=" + this.getSubscriptions();
    }

    @NotNull
    public String toString() {
        return "MqttSubscribe{" + this.toAttributeString() + '}';
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Mqtt3SubscribeView)) {
            return false;
        }
        Mqtt3SubscribeView that = (Mqtt3SubscribeView)o;
        return this.delegate.equals(that.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }
}

