/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.client.internal.mqtt.mqtt3;

import com.hivemq.client.internal.mqtt.MqttBlockingClient;
import com.hivemq.client.internal.mqtt.exceptions.mqtt3.Mqtt3ExceptionFactory;
import com.hivemq.client.internal.mqtt.message.connect.MqttConnect;
import com.hivemq.client.internal.mqtt.message.connect.connack.mqtt3.Mqtt3ConnAckView;
import com.hivemq.client.internal.mqtt.message.connect.mqtt3.Mqtt3ConnectView;
import com.hivemq.client.internal.mqtt.message.connect.mqtt3.Mqtt3ConnectViewBuilder;
import com.hivemq.client.internal.mqtt.message.disconnect.mqtt3.Mqtt3DisconnectView;
import com.hivemq.client.internal.mqtt.message.publish.MqttPublish;
import com.hivemq.client.internal.mqtt.message.publish.mqtt3.Mqtt3PublishView;
import com.hivemq.client.internal.mqtt.message.publish.mqtt3.Mqtt3PublishViewBuilder;
import com.hivemq.client.internal.mqtt.message.subscribe.MqttSubscribe;
import com.hivemq.client.internal.mqtt.message.subscribe.mqtt3.Mqtt3SubscribeViewBuilder;
import com.hivemq.client.internal.mqtt.message.subscribe.suback.mqtt3.Mqtt3SubAckView;
import com.hivemq.client.internal.mqtt.message.unsubscribe.MqttUnsubscribe;
import com.hivemq.client.internal.mqtt.message.unsubscribe.mqtt3.Mqtt3UnsubscribeViewBuilder;
import com.hivemq.client.internal.mqtt.mqtt3.Mqtt3AsyncClientView;
import com.hivemq.client.internal.mqtt.mqtt3.Mqtt3ClientConfigView;
import com.hivemq.client.internal.mqtt.mqtt3.Mqtt3RxClientView;
import com.hivemq.client.internal.mqtt.util.MqttChecks;
import com.hivemq.client.internal.shaded.org.jetbrains.annotations.NotNull;
import com.hivemq.client.internal.shaded.org.jetbrains.annotations.Nullable;
import com.hivemq.client.internal.util.Checks;
import com.hivemq.client.mqtt.MqttGlobalPublishFilter;
import com.hivemq.client.mqtt.mqtt3.Mqtt3AsyncClient;
import com.hivemq.client.mqtt.mqtt3.Mqtt3BlockingClient;
import com.hivemq.client.mqtt.mqtt3.Mqtt3ClientConfig;
import com.hivemq.client.mqtt.mqtt3.Mqtt3RxClient;
import com.hivemq.client.mqtt.mqtt3.message.connect.Mqtt3Connect;
import com.hivemq.client.mqtt.mqtt3.message.connect.connack.Mqtt3ConnAck;
import com.hivemq.client.mqtt.mqtt3.message.publish.Mqtt3Publish;
import com.hivemq.client.mqtt.mqtt3.message.subscribe.Mqtt3Subscribe;
import com.hivemq.client.mqtt.mqtt3.message.subscribe.suback.Mqtt3SubAck;
import com.hivemq.client.mqtt.mqtt3.message.unsubscribe.Mqtt3Unsubscribe;
import com.hivemq.client.mqtt.mqtt5.Mqtt5BlockingClient;
import com.hivemq.client.mqtt.mqtt5.exceptions.Mqtt5MessageException;
import java.util.Optional;
import java.util.concurrent.TimeUnit;

public class Mqtt3BlockingClientView
implements Mqtt3BlockingClient {
    @NotNull
    private final MqttBlockingClient delegate;
    @NotNull
    private final Mqtt3ClientConfigView clientConfig;

    Mqtt3BlockingClientView(@NotNull MqttBlockingClient delegate) {
        this.delegate = delegate;
        this.clientConfig = new Mqtt3ClientConfigView(delegate.getConfig());
    }

    @Override
    @NotNull
    public Mqtt3ConnAck connect() {
        return this.connect(Mqtt3ConnectView.DEFAULT);
    }

    @Override
    @NotNull
    public Mqtt3ConnAck connect(@Nullable Mqtt3Connect connect) {
        MqttConnect mqttConnect = MqttChecks.connect(connect);
        try {
            return Mqtt3ConnAckView.of(this.delegate.connect(mqttConnect));
        }
        catch (Mqtt5MessageException e) {
            throw Mqtt3ExceptionFactory.mapWithStackTrace(e);
        }
    }

    public @NotNull Mqtt3ConnectViewBuilder.Send<Mqtt3ConnAck> connectWith() {
        return new Mqtt3ConnectViewBuilder.Send<Mqtt3ConnAck>(this::connect);
    }

    @Override
    @NotNull
    public Mqtt3SubAck subscribe(@Nullable Mqtt3Subscribe subscribe) {
        MqttSubscribe mqttSubscribe = MqttChecks.subscribe(subscribe);
        try {
            return Mqtt3SubAckView.of(this.delegate.subscribe(mqttSubscribe));
        }
        catch (Mqtt5MessageException e) {
            throw Mqtt3ExceptionFactory.mapWithStackTrace(e);
        }
    }

    public @NotNull Mqtt3SubscribeViewBuilder.Send<Mqtt3SubAck> subscribeWith() {
        return new Mqtt3SubscribeViewBuilder.Send<Mqtt3SubAck>(this::subscribe);
    }

    @Override
    @NotNull
    public Mqtt3BlockingClient.Mqtt3Publishes publishes(@Nullable MqttGlobalPublishFilter filter) {
        return this.publishes(filter, false);
    }

    @Override
    @NotNull
    public Mqtt3BlockingClient.Mqtt3Publishes publishes(@Nullable MqttGlobalPublishFilter filter, boolean manualAcknowledgement) {
        Checks.notNull(filter, "Global publish filter");
        return new Mqtt3PublishesView(this.delegate.publishes(filter, manualAcknowledgement));
    }

    @Override
    public void unsubscribe(@Nullable Mqtt3Unsubscribe unsubscribe) {
        MqttUnsubscribe mqttUnsubscribe = MqttChecks.unsubscribe(unsubscribe);
        try {
            this.delegate.unsubscribe(mqttUnsubscribe);
        }
        catch (Mqtt5MessageException e) {
            throw Mqtt3ExceptionFactory.mapWithStackTrace(e);
        }
    }

    @Override
    public @NotNull Mqtt3UnsubscribeViewBuilder.SendVoid unsubscribeWith() {
        return new Mqtt3UnsubscribeViewBuilder.SendVoid(this::unsubscribe);
    }

    @Override
    public void publish(@Nullable Mqtt3Publish publish) {
        MqttPublish mqttPublish = MqttChecks.publish(publish);
        try {
            this.delegate.publish(mqttPublish);
        }
        catch (Mqtt5MessageException e) {
            throw Mqtt3ExceptionFactory.mapWithStackTrace(e);
        }
    }

    @Override
    public @NotNull Mqtt3PublishViewBuilder.SendVoid publishWith() {
        return new Mqtt3PublishViewBuilder.SendVoid(this::publish);
    }

    @Override
    public void disconnect() {
        try {
            this.delegate.disconnect(Mqtt3DisconnectView.DELEGATE);
        }
        catch (Mqtt5MessageException e) {
            throw Mqtt3ExceptionFactory.mapWithStackTrace(e);
        }
    }

    @Override
    @NotNull
    public Mqtt3ClientConfig getConfig() {
        return this.clientConfig;
    }

    @Override
    @NotNull
    public Mqtt3RxClient toRx() {
        return new Mqtt3RxClientView(this.delegate.toRx());
    }

    @Override
    @NotNull
    public Mqtt3AsyncClient toAsync() {
        return new Mqtt3AsyncClientView(this.delegate.toAsync());
    }

    private static class Mqtt3PublishesView
    implements Mqtt3BlockingClient.Mqtt3Publishes {
        @NotNull
        private final Mqtt5BlockingClient.Mqtt5Publishes delegate;

        Mqtt3PublishesView(@NotNull Mqtt5BlockingClient.Mqtt5Publishes delegate) {
            this.delegate = delegate;
        }

        @Override
        @NotNull
        public Mqtt3Publish receive() throws InterruptedException {
            try {
                return Mqtt3PublishView.of(this.delegate.receive());
            }
            catch (RuntimeException e) {
                throw Mqtt3ExceptionFactory.mapWithStackTrace(e);
            }
        }

        @Override
        @NotNull
        public Optional<Mqtt3Publish> receive(long timeout, @Nullable TimeUnit timeUnit) throws InterruptedException {
            if (timeout < 0L) {
                throw new IllegalArgumentException("Timeout must be greater than 0.");
            }
            Checks.notNull(timeUnit, "Time unit");
            try {
                return this.delegate.receive(timeout, timeUnit).map(Mqtt3PublishView.JAVA_MAPPER);
            }
            catch (RuntimeException e) {
                throw Mqtt3ExceptionFactory.mapWithStackTrace(e);
            }
        }

        @Override
        @NotNull
        public Optional<Mqtt3Publish> receiveNow() {
            try {
                return this.delegate.receiveNow().map(Mqtt3PublishView.JAVA_MAPPER);
            }
            catch (RuntimeException e) {
                throw Mqtt3ExceptionFactory.mapWithStackTrace(e);
            }
        }

        @Override
        public void close() {
            this.delegate.close();
        }
    }
}

