/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.client.internal.mqtt.mqtt3;

import com.hivemq.client.annotations.Immutable;
import com.hivemq.client.internal.mqtt.MqttClientConfig;
import com.hivemq.client.internal.mqtt.message.auth.MqttSimpleAuth;
import com.hivemq.client.internal.mqtt.message.auth.mqtt3.Mqtt3SimpleAuthView;
import com.hivemq.client.internal.mqtt.message.publish.MqttWillPublish;
import com.hivemq.client.internal.mqtt.message.publish.mqtt3.Mqtt3PublishView;
import com.hivemq.client.internal.shaded.org.jetbrains.annotations.NotNull;
import com.hivemq.client.internal.shaded.org.jetbrains.annotations.Nullable;
import com.hivemq.client.mqtt.MqttClientExecutorConfig;
import com.hivemq.client.mqtt.MqttClientState;
import com.hivemq.client.mqtt.MqttClientTransportConfig;
import com.hivemq.client.mqtt.MqttVersion;
import com.hivemq.client.mqtt.datatypes.MqttClientIdentifier;
import com.hivemq.client.mqtt.lifecycle.MqttClientAutoReconnect;
import com.hivemq.client.mqtt.lifecycle.MqttClientConnectedListener;
import com.hivemq.client.mqtt.lifecycle.MqttClientDisconnectedListener;
import com.hivemq.client.mqtt.mqtt3.Mqtt3ClientConfig;
import com.hivemq.client.mqtt.mqtt3.Mqtt3ClientConnectionConfig;
import com.hivemq.client.mqtt.mqtt3.message.auth.Mqtt3SimpleAuth;
import com.hivemq.client.mqtt.mqtt3.message.publish.Mqtt3Publish;
import java.util.List;
import java.util.Optional;

public class Mqtt3ClientConfigView
implements Mqtt3ClientConfig {
    @NotNull
    private final MqttClientConfig delegate;

    public Mqtt3ClientConfigView(@NotNull MqttClientConfig delegate) {
        this.delegate = delegate;
    }

    @Override
    @NotNull
    public MqttVersion getMqttVersion() {
        return this.delegate.getMqttVersion();
    }

    @Override
    @NotNull
    public Optional<MqttClientIdentifier> getClientIdentifier() {
        return this.delegate.getClientIdentifier();
    }

    @Override
    @NotNull
    public MqttClientTransportConfig getTransportConfig() {
        return this.delegate.getTransportConfig();
    }

    @Override
    @NotNull
    public MqttClientExecutorConfig getExecutorConfig() {
        return this.delegate.getExecutorConfig();
    }

    @Override
    @NotNull
    public Optional<MqttClientAutoReconnect> getAutomaticReconnect() {
        return this.delegate.getAutomaticReconnect();
    }

    @Override
    @NotNull
    public Optional<Mqtt3SimpleAuth> getSimpleAuth() {
        return Optional.ofNullable(this.getRawSimpleAuth());
    }

    @Nullable
    private Mqtt3SimpleAuth getRawSimpleAuth() {
        MqttSimpleAuth simpleAuth = this.delegate.getConnectDefaults().getSimpleAuth();
        return simpleAuth == null ? null : Mqtt3SimpleAuthView.of(simpleAuth);
    }

    @Override
    @NotNull
    public Optional<Mqtt3Publish> getWillPublish() {
        return Optional.ofNullable(this.getRawWillPublish());
    }

    @Nullable
    private Mqtt3Publish getRawWillPublish() {
        MqttWillPublish willPublish = this.delegate.getConnectDefaults().getWillPublish();
        return willPublish == null ? null : Mqtt3PublishView.of(willPublish);
    }

    @Override
    @NotNull
    public @Immutable @NotNull List<@NotNull MqttClientConnectedListener> getConnectedListeners() {
        return this.delegate.getConnectedListeners();
    }

    @Override
    @NotNull
    public @Immutable @NotNull List<@NotNull MqttClientDisconnectedListener> getDisconnectedListeners() {
        return this.delegate.getDisconnectedListeners();
    }

    @Override
    @NotNull
    public MqttClientState getState() {
        return this.delegate.getState();
    }

    @Override
    @NotNull
    public Optional<Mqtt3ClientConnectionConfig> getConnectionConfig() {
        return Optional.ofNullable(this.delegate.getRawConnectionConfig());
    }
}

