/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.client.internal.util;

import com.hivemq.client.internal.shaded.org.jetbrains.annotations.Contract;
import com.hivemq.client.internal.shaded.org.jetbrains.annotations.NotNull;
import com.hivemq.client.internal.shaded.org.jetbrains.annotations.Nullable;
import com.hivemq.client.internal.util.UnsignedDataTypes;
import com.hivemq.client.internal.util.collections.ImmutableList;

public final class Checks {
    @Contract(value="null, _ -> fail")
    @NotNull
    public static <T> T notNull(@Nullable T object, @NotNull String name) {
        if (object == null) {
            throw new NullPointerException(name + " must not be null.");
        }
        return object;
    }

    @Contract(value="null, _ -> fail")
    @NotNull
    public static String notEmpty(@Nullable String string, @NotNull String name) {
        Checks.notNull(string, name);
        if (string.isEmpty()) {
            throw new IllegalArgumentException(name + " must be at least one character long.");
        }
        return string;
    }

    @Contract(value="null, _, _ -> fail")
    @NotNull
    public static <S, T extends S> T notImplemented(@Nullable S object, @NotNull Class<T> type, @NotNull String name) {
        return Checks.notImplementedInternal(Checks.notNull(object, name), type, name);
    }

    @Contract(value="null, _, _ -> null")
    @Nullable
    public static <S, T extends S> T notImplementedOrNull(@Nullable S object, @NotNull Class<T> type, @NotNull String name) {
        return object == null ? null : (T)Checks.notImplementedInternal(object, type, name);
    }

    @NotNull
    private static <S, T extends S> T notImplementedInternal(@NotNull S object, @NotNull Class<T> type, @NotNull String name) {
        if (!type.isInstance(object)) {
            throw new IllegalArgumentException(name + " must not be implemented by the user, but was implemented by " + object.getClass().getTypeName() + ".");
        }
        return (T)object;
    }

    @Contract(value="null, _ -> fail")
    @NotNull
    public static <T> @NotNull T @NotNull [] elementsNotNull(@Nullable @Nullable T @Nullable [] array, @NotNull String name) {
        Checks.notNull(array, name);
        for (int i = 0; i < array.length; ++i) {
            Checks.elementNotNull(array[i], name, i);
        }
        return array;
    }

    @Contract(value="null, _, _ -> fail")
    @NotNull
    public static <E> E elementNotNull(@Nullable E e, @NotNull String name, int index) {
        if (e == null) {
            throw new NullPointerException(name + " must not contain a null element, found at index " + index + ".");
        }
        return e;
    }

    @NotNull
    public static <S, T extends S> ImmutableList<T> elementsNotImplemented(@NotNull ImmutableList<S> list, @NotNull Class<T> type, @NotNull String name) {
        for (int i = 0; i < list.size(); ++i) {
            Checks.notImplementedInternal(list.get(i), type, name);
        }
        return list;
    }

    public static long range(long value, long min, long max, @NotNull String name) {
        if (value < min) {
            throw new IllegalArgumentException(name + " must not be smaller than " + min);
        }
        if (value > max) {
            throw new IllegalArgumentException(name + " must not be greater than " + max);
        }
        return value;
    }

    public static int unsignedShort(int value, @NotNull String name) {
        if (!UnsignedDataTypes.isUnsignedShort(value)) {
            throw new IllegalArgumentException(name + " must not exceed the value range of unsigned short [0, " + 65535 + "], but was " + value + ".");
        }
        return value;
    }

    public static int unsignedShortNotZero(int value, @NotNull String name) {
        if (value == 0) {
            throw new IllegalArgumentException(name + " must not be zero.");
        }
        Checks.unsignedShort(value, name);
        return value;
    }

    public static long unsignedInt(long value, @NotNull String name) {
        if (!UnsignedDataTypes.isUnsignedInt(value)) {
            throw new IllegalArgumentException(name + " must not exceed the value range of unsigned int [0, " + 0xFFFFFFFFL + "], but was " + value + ".");
        }
        return value;
    }

    public static int index(int index, int size) {
        if (index < 0 || index >= size) {
            if (index < 0) {
                throw new IndexOutOfBoundsException("Index must not be smaller than 0, but was " + index + ".");
            }
            throw new IndexOutOfBoundsException("Index must not be greater than or equal to the size (" + size + "), but was " + index + ".");
        }
        return index;
    }

    public static int cursorIndex(int index, int size) {
        if (index < 0 || index > size) {
            if (index < 0) {
                throw new IndexOutOfBoundsException("Cursor index must not be smaller than 0, but was " + index + ".");
            }
            throw new IndexOutOfBoundsException("Cursor index must not be greater than the size (" + size + "), but was " + index + ".");
        }
        return index;
    }

    public static void indexRange(int start, int end, int size) {
        if (start < 0 || start > end || end > size) {
            if (start < 0) {
                throw new IndexOutOfBoundsException("Start index must not be smaller than 0, but was " + start + ".");
            }
            if (start > end) {
                throw new IndexOutOfBoundsException("Start index must not be greater than the end index, but " + start + " > " + end + ".");
            }
            throw new IndexOutOfBoundsException("End index must not be greater than or equal to the size (" + size + "), but was " + end + ".");
        }
    }

    @Contract(value="false, _ -> fail")
    public static void state(boolean condition, @NotNull String message) {
        if (!condition) {
            throw new IllegalStateException(message);
        }
    }

    @NotNull
    public static <T> T stateNotNull(@Nullable T object, @NotNull String name) {
        if (object == null) {
            throw new IllegalStateException(name + " must not be null. This must not happen and is a bug.");
        }
        return object;
    }

    private Checks() {
    }
}

