/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.client.internal.util.collections;

import com.hivemq.client.internal.annotations.NotThreadSafe;
import com.hivemq.client.internal.shaded.org.jetbrains.annotations.NotNull;
import com.hivemq.client.internal.shaded.org.jetbrains.annotations.Nullable;
import java.util.NoSuchElementException;

@NotThreadSafe
public class ChunkedArrayQueue<E>
implements Iterable<E> {
    private final int chunkSize;
    @Nullable
    private E single;
    @Nullable
    private @Nullable Object @Nullable [] producerChunk;
    @Nullable
    private @Nullable Object @Nullable [] consumerChunk;
    private int producerIndex;
    private int consumerIndex;
    private int size;

    public ChunkedArrayQueue(int chunkSize) {
        this.chunkSize = chunkSize;
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public void offer(@NotNull E e) {
        if (this.size == 0) {
            this.size = 1;
            this.single = e;
            return;
        }
        if (this.size == 1) {
            E single;
            if (this.producerChunk == null) {
                this.consumerChunk = new Object[this.chunkSize];
                this.producerChunk = this.consumerChunk;
            }
            if ((single = this.single) != null) {
                this.size = 0;
                this.single = null;
                this.offerQueue(single);
            }
        }
        this.offerQueue(e);
    }

    private void offerQueue(@NotNull E e) {
        Object[] producerChunk = this.producerChunk;
        assert (producerChunk != null);
        int producerIndex = this.producerIndex;
        if (producerIndex == this.chunkSize || producerChunk == this.consumerChunk && producerChunk[producerIndex] != null) {
            if (this.size >= this.chunkSize) {
                Object[] chunk = new Object[this.chunkSize];
                Object o = producerChunk[producerIndex - 1];
                producerChunk[producerIndex - 1] = chunk;
                producerChunk = chunk;
                producerChunk[0] = o;
                this.producerChunk = chunk;
                producerIndex = 1;
            } else {
                producerIndex = 0;
            }
        }
        producerChunk[producerIndex] = e;
        this.producerIndex = producerIndex + 1;
        ++this.size;
    }

    @Nullable
    public E poll() {
        Object e;
        E single = this.single;
        if (single != null) {
            this.size = 0;
            this.single = null;
            return single;
        }
        if (this.consumerChunk == null) {
            return null;
        }
        Object[] consumerChunk = this.consumerChunk;
        int consumerIndex = this.consumerIndex;
        Object o = consumerChunk[consumerIndex];
        if (o == null) {
            return null;
        }
        consumerChunk[consumerIndex] = null;
        if (o.getClass() == Object[].class) {
            Object[] nextChunk = (Object[])o;
            this.consumerChunk = nextChunk;
            consumerIndex = 1;
            e = nextChunk[0];
            nextChunk[0] = null;
        } else {
            e = o;
            if (++consumerIndex == this.chunkSize) {
                consumerIndex = 0;
            }
        }
        --this.size;
        this.consumerIndex = consumerIndex;
        return (E)e;
    }

    @Nullable
    public E peek() {
        Object e;
        if (this.single != null) {
            return this.single;
        }
        if (this.consumerChunk == null) {
            return null;
        }
        Object o = this.consumerChunk[this.consumerIndex];
        if (o == null) {
            return null;
        }
        if (o.getClass() == Object[].class) {
            Object[] nextChunk = (Object[])o;
            e = nextChunk[0];
        } else {
            e = o;
        }
        return (E)e;
    }

    public void clear() {
        while (this.poll() != null) {
        }
    }

    @NotNull
    public Iterator iterator() {
        return new Iterator();
    }

    public class Iterator
    implements java.util.Iterator<E> {
        @Nullable
        private @Nullable Object @Nullable [] iteratorChunk;
        private int iteratorIndex;
        private int iterated;

        Iterator() {
            this.reset();
        }

        public void reset() {
            this.iteratorChunk = ChunkedArrayQueue.this.consumerChunk;
            this.iteratorIndex = ChunkedArrayQueue.this.consumerIndex;
            this.iterated = 0;
        }

        @Override
        public boolean hasNext() {
            return this.iterated < ChunkedArrayQueue.this.size;
        }

        @Override
        @NotNull
        public E next() {
            Object e;
            Object iteratorSingle = ChunkedArrayQueue.this.single;
            if (iteratorSingle != null) {
                if (this.iterated > 0) {
                    throw new NoSuchElementException();
                }
                this.iterated = 1;
                return iteratorSingle;
            }
            if (this.iteratorChunk == null) {
                throw new NoSuchElementException();
            }
            Object o = this.iteratorChunk[this.iteratorIndex];
            if (o == null) {
                throw new NoSuchElementException();
            }
            if (o.getClass() == Object[].class) {
                Object[] nextChunk = (Object[])o;
                this.iteratorChunk = nextChunk;
                this.iteratorIndex = 1;
                e = nextChunk[0];
            } else {
                e = o;
                ++this.iteratorIndex;
                if (this.iteratorIndex == ChunkedArrayQueue.this.chunkSize) {
                    this.iteratorIndex = 0;
                }
            }
            ++this.iterated;
            return e;
        }

        @Override
        public void remove() {
            for (int i = 0; i < this.iterated; ++i) {
                ChunkedArrayQueue.this.poll();
            }
            this.iterated = 0;
        }

        public int getIterated() {
            return this.iterated;
        }
    }
}

