/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.client.internal.util.collections;

import com.hivemq.client.annotations.Immutable;
import com.hivemq.client.internal.shaded.org.jetbrains.annotations.NotNull;
import com.hivemq.client.internal.shaded.org.jetbrains.annotations.Nullable;
import com.hivemq.client.internal.util.collections.ImmutableIntList;

@Immutable
class ImmutableEmptyIntList
implements ImmutableIntList {
    @NotNull
    static final ImmutableEmptyIntList INSTANCE = new ImmutableEmptyIntList();

    private ImmutableEmptyIntList() {
    }

    @Override
    public int size() {
        return 0;
    }

    @Override
    public int get(int index) {
        throw new IndexOutOfBoundsException("Empty int list");
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ImmutableIntList)) {
            return false;
        }
        return ((ImmutableIntList)o).size() == 0;
    }

    public int hashCode() {
        return 1;
    }

    @NotNull
    public String toString() {
        return "[]";
    }
}

