/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.client.util;

import com.hivemq.client.internal.shaded.org.jetbrains.annotations.NotNull;
import com.hivemq.client.internal.util.Checks;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLException;
import javax.net.ssl.TrustManagerFactory;

public class KeyStoreUtil {
    @NotNull
    private static final String KEYSTORE_TYPE = "JKS";

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public static TrustManagerFactory trustManagerFromKeystore(@NotNull File trustStoreFile, @NotNull String trustStorePassword) throws SSLException {
        Checks.notNull(trustStoreFile, "Trust store file");
        try (FileInputStream fileInputStream = new FileInputStream(trustStoreFile);){
            KeyStore keyStore = KeyStore.getInstance(KEYSTORE_TYPE);
            keyStore.load(fileInputStream, trustStorePassword.toCharArray());
            TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            tmf.init(keyStore);
            TrustManagerFactory trustManagerFactory = tmf;
            return trustManagerFactory;
        }
        catch (IOException | KeyStoreException e) {
            throw new SSLException("Not able to open or read trust store '" + trustStoreFile.getAbsolutePath() + "'", e);
        }
        catch (NoSuchAlgorithmException | CertificateException e) {
            throw new SSLException("Not able to read certificate from trust store '" + trustStoreFile.getAbsolutePath() + "'", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public static KeyManagerFactory keyManagerFromKeystore(@NotNull File keyStoreFile, @NotNull String keyStorePassword, @NotNull String privateKeyPassword) throws SSLException {
        Checks.notNull(keyStoreFile, "Key store file");
        try (FileInputStream fileInputStream = new FileInputStream(keyStoreFile);){
            KeyStore keyStore = KeyStore.getInstance(KEYSTORE_TYPE);
            keyStore.load(fileInputStream, keyStorePassword.toCharArray());
            KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            kmf.init(keyStore, privateKeyPassword.toCharArray());
            KeyManagerFactory keyManagerFactory = kmf;
            return keyManagerFactory;
        }
        catch (UnrecoverableKeyException e) {
            throw new SSLException("Not able to recover key from key store, please check your private key password and your key store password", e);
        }
        catch (IOException | KeyStoreException e) {
            throw new SSLException("Not able to open or read key store '" + keyStoreFile.getAbsolutePath() + "'", e);
        }
        catch (NoSuchAlgorithmException | CertificateException e) {
            throw new SSLException("Not able to read certificate from key store '" + keyStoreFile.getAbsolutePath() + "'", e);
        }
    }
}

