/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.client.internal.mqtt;

import com.hivemq.client.internal.mqtt.MqttClientConnectionConfig;
import com.hivemq.client.internal.mqtt.MqttClientExecutorConfigImpl;
import com.hivemq.client.internal.mqtt.MqttClientTransportConfigImpl;
import com.hivemq.client.internal.mqtt.advanced.MqttClientAdvancedConfig;
import com.hivemq.client.internal.mqtt.datatypes.MqttClientIdentifierImpl;
import com.hivemq.client.internal.mqtt.ioc.ClientComponent;
import com.hivemq.client.internal.mqtt.ioc.SingletonComponent;
import com.hivemq.client.internal.mqtt.message.auth.MqttSimpleAuth;
import com.hivemq.client.internal.mqtt.message.publish.MqttWillPublish;
import com.hivemq.client.internal.netty.NettyEventLoopProvider;
import com.hivemq.client.internal.shaded.io.netty.channel.EventLoop;
import com.hivemq.client.internal.shaded.io.netty.handler.ssl.SslContext;
import com.hivemq.client.internal.shaded.org.jetbrains.annotations.NotNull;
import com.hivemq.client.internal.shaded.org.jetbrains.annotations.Nullable;
import com.hivemq.client.internal.util.ExecutorUtil;
import com.hivemq.client.internal.util.collections.ImmutableList;
import com.hivemq.client.mqtt.MqttClientState;
import com.hivemq.client.mqtt.MqttVersion;
import com.hivemq.client.mqtt.datatypes.MqttClientIdentifier;
import com.hivemq.client.mqtt.lifecycle.MqttClientAutoReconnect;
import com.hivemq.client.mqtt.lifecycle.MqttClientConnectedListener;
import com.hivemq.client.mqtt.lifecycle.MqttClientDisconnectedListener;
import com.hivemq.client.mqtt.mqtt5.Mqtt5ClientConfig;
import com.hivemq.client.mqtt.mqtt5.Mqtt5ClientConnectionConfig;
import com.hivemq.client.mqtt.mqtt5.auth.Mqtt5EnhancedAuthMechanism;
import com.hivemq.client.mqtt.mqtt5.message.auth.Mqtt5SimpleAuth;
import com.hivemq.client.mqtt.mqtt5.message.publish.Mqtt5WillPublish;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;

public class MqttClientConfig
implements Mqtt5ClientConfig {
    @NotNull
    private final MqttVersion mqttVersion;
    @NotNull
    private volatile MqttClientIdentifierImpl clientIdentifier;
    @NotNull
    private final MqttClientTransportConfigImpl transportConfig;
    @NotNull
    private final MqttClientExecutorConfigImpl executorConfig;
    @NotNull
    private final MqttClientAdvancedConfig advancedConfig;
    @NotNull
    private final ConnectDefaults connectDefaults;
    @NotNull
    private final ImmutableList<MqttClientConnectedListener> connectedListeners;
    @NotNull
    private final ImmutableList<MqttClientDisconnectedListener> disconnectedListeners;
    @NotNull
    private final ClientComponent clientComponent;
    @Nullable
    private volatile EventLoop eventLoop;
    private int eventLoopAcquires;
    private long eventLoopAcquireCount;
    @NotNull
    private final @NotNull AtomicReference<@NotNull MqttClientState> state;
    @Nullable
    private volatile MqttClientConnectionConfig connectionConfig;
    @NotNull
    private MqttClientTransportConfigImpl currentTransportConfig;
    @Nullable
    private SslContext currentSslContext;
    private boolean resubscribeIfSessionPresent;
    private boolean resubscribeIfSessionExpired;
    private boolean republishIfSessionExpired;

    public MqttClientConfig(@NotNull MqttVersion mqttVersion, @NotNull MqttClientIdentifierImpl clientIdentifier, @NotNull MqttClientTransportConfigImpl transportConfig, @NotNull MqttClientExecutorConfigImpl executorConfig, @NotNull MqttClientAdvancedConfig advancedConfig, @NotNull ConnectDefaults connectDefaults, @NotNull ImmutableList<MqttClientConnectedListener> connectedListeners, @NotNull ImmutableList<MqttClientDisconnectedListener> disconnectedListeners) {
        this.mqttVersion = mqttVersion;
        this.clientIdentifier = clientIdentifier;
        this.transportConfig = transportConfig;
        this.executorConfig = executorConfig;
        this.advancedConfig = advancedConfig;
        this.connectDefaults = connectDefaults;
        this.connectedListeners = connectedListeners;
        this.disconnectedListeners = disconnectedListeners;
        this.clientComponent = SingletonComponent.INSTANCE.clientComponentBuilder().clientConfig(this).build();
        this.state = new AtomicReference<MqttClientState>(MqttClientState.DISCONNECTED);
        this.currentTransportConfig = transportConfig;
    }

    @Override
    @NotNull
    public MqttVersion getMqttVersion() {
        return this.mqttVersion;
    }

    @Override
    @NotNull
    public Optional<MqttClientIdentifier> getClientIdentifier() {
        return this.clientIdentifier == MqttClientIdentifierImpl.REQUEST_CLIENT_IDENTIFIER_FROM_SERVER ? Optional.empty() : Optional.of(this.clientIdentifier);
    }

    @NotNull
    public MqttClientIdentifierImpl getRawClientIdentifier() {
        return this.clientIdentifier;
    }

    public void setClientIdentifier(@NotNull MqttClientIdentifierImpl clientIdentifier) {
        this.clientIdentifier = clientIdentifier;
    }

    @Override
    @NotNull
    public MqttClientTransportConfigImpl getTransportConfig() {
        return this.transportConfig;
    }

    @Override
    @NotNull
    public MqttClientExecutorConfigImpl getExecutorConfig() {
        return this.executorConfig;
    }

    @Override
    @NotNull
    public MqttClientAdvancedConfig getAdvancedConfig() {
        return this.advancedConfig;
    }

    @Override
    @NotNull
    public Optional<Mqtt5SimpleAuth> getSimpleAuth() {
        return Optional.ofNullable(this.connectDefaults.simpleAuth);
    }

    @Override
    @NotNull
    public Optional<Mqtt5EnhancedAuthMechanism> getEnhancedAuthMechanism() {
        return Optional.ofNullable(this.connectDefaults.enhancedAuthMechanism);
    }

    @Override
    @NotNull
    public Optional<Mqtt5WillPublish> getWillPublish() {
        return Optional.ofNullable(this.connectDefaults.willPublish);
    }

    @NotNull
    public ConnectDefaults getConnectDefaults() {
        return this.connectDefaults;
    }

    @Override
    @NotNull
    public Optional<MqttClientAutoReconnect> getAutomaticReconnect() {
        for (MqttClientDisconnectedListener disconnectedListener : this.disconnectedListeners) {
            if (!(disconnectedListener instanceof MqttClientAutoReconnect)) continue;
            return Optional.of((MqttClientAutoReconnect)disconnectedListener);
        }
        return Optional.empty();
    }

    @NotNull
    public ImmutableList<MqttClientConnectedListener> getConnectedListeners() {
        return this.connectedListeners;
    }

    @NotNull
    public ImmutableList<MqttClientDisconnectedListener> getDisconnectedListeners() {
        return this.disconnectedListeners;
    }

    @NotNull
    public ClientComponent getClientComponent() {
        return this.clientComponent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public EventLoop acquireEventLoop() {
        AtomicReference<MqttClientState> atomicReference = this.state;
        synchronized (atomicReference) {
            ++this.eventLoopAcquires;
            ++this.eventLoopAcquireCount;
            EventLoop eventLoop = this.eventLoop;
            if (eventLoop == null) {
                this.eventLoop = eventLoop = NettyEventLoopProvider.INSTANCE.acquireEventLoop(this.executorConfig.getRawNettyExecutor(), this.executorConfig.getRawNettyThreads());
            }
            return eventLoop;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseEventLoop() {
        AtomicReference<MqttClientState> atomicReference = this.state;
        synchronized (atomicReference) {
            if (--this.eventLoopAcquires == 0) {
                EventLoop eventLoop = this.eventLoop;
                long eventLoopAcquireCount = this.eventLoopAcquireCount;
                assert (eventLoop != null) : "eventLoopAcquires was > 0 -> eventLoop != null";
                eventLoop.execute(() -> {
                    AtomicReference<MqttClientState> atomicReference = this.state;
                    synchronized (atomicReference) {
                        if (eventLoopAcquireCount == this.eventLoopAcquireCount) {
                            this.eventLoop = null;
                            NettyEventLoopProvider.INSTANCE.releaseEventLoop(this.executorConfig.getRawNettyExecutor());
                        }
                    }
                });
            }
        }
    }

    public boolean executeInEventLoop(@NotNull Runnable runnable) {
        EventLoop eventLoop = this.eventLoop;
        if (eventLoop == null) {
            return false;
        }
        return ExecutorUtil.execute(eventLoop, runnable);
    }

    @Override
    @NotNull
    public MqttClientState getState() {
        return this.state.get();
    }

    @NotNull
    public @NotNull AtomicReference<@NotNull MqttClientState> getRawState() {
        return this.state;
    }

    @Override
    @NotNull
    public Optional<Mqtt5ClientConnectionConfig> getConnectionConfig() {
        return Optional.ofNullable(this.connectionConfig);
    }

    @Nullable
    public MqttClientConnectionConfig getRawConnectionConfig() {
        return this.connectionConfig;
    }

    public void setConnectionConfig(@Nullable MqttClientConnectionConfig connectionConfig) {
        this.connectionConfig = connectionConfig;
    }

    @NotNull
    public MqttClientTransportConfigImpl getCurrentTransportConfig() {
        return this.currentTransportConfig;
    }

    public void setCurrentTransportConfig(@NotNull MqttClientTransportConfigImpl currentTransportConfig) {
        if (!this.currentTransportConfig.equals(currentTransportConfig)) {
            this.currentTransportConfig = currentTransportConfig;
            this.currentSslContext = null;
        }
    }

    @Nullable
    public SslContext getCurrentSslContext() {
        return this.currentSslContext;
    }

    public void setCurrentSslContext(@Nullable SslContext currentSslContext) {
        this.currentSslContext = currentSslContext;
    }

    public boolean isResubscribeIfSessionPresent() {
        return this.resubscribeIfSessionPresent;
    }

    public void setResubscribeIfSessionPresent(boolean resubscribeIfSessionPresent) {
        this.resubscribeIfSessionPresent = resubscribeIfSessionPresent;
    }

    public boolean isResubscribeIfSessionExpired() {
        return this.resubscribeIfSessionExpired;
    }

    public void setResubscribeIfSessionExpired(boolean resubscribeIfSessionExpired) {
        this.resubscribeIfSessionExpired = resubscribeIfSessionExpired;
    }

    public boolean isRepublishIfSessionExpired() {
        return this.republishIfSessionExpired;
    }

    public void setRepublishIfSessionExpired(boolean republishIfSessionExpired) {
        this.republishIfSessionExpired = republishIfSessionExpired;
    }

    public static class ConnectDefaults {
        @NotNull
        private static final ConnectDefaults EMPTY = new ConnectDefaults(null, null, null);
        @Nullable
        final MqttSimpleAuth simpleAuth;
        @Nullable
        final Mqtt5EnhancedAuthMechanism enhancedAuthMechanism;
        @Nullable
        final MqttWillPublish willPublish;

        @NotNull
        public static ConnectDefaults of(@Nullable MqttSimpleAuth simpleAuth, @Nullable Mqtt5EnhancedAuthMechanism enhancedAuthMechanism, @Nullable MqttWillPublish willPublish) {
            if (simpleAuth == null && enhancedAuthMechanism == null && willPublish == null) {
                return EMPTY;
            }
            return new ConnectDefaults(simpleAuth, enhancedAuthMechanism, willPublish);
        }

        private ConnectDefaults(@Nullable MqttSimpleAuth simpleAuth, @Nullable Mqtt5EnhancedAuthMechanism enhancedAuthMechanism, @Nullable MqttWillPublish willPublish) {
            this.simpleAuth = simpleAuth;
            this.enhancedAuthMechanism = enhancedAuthMechanism;
            this.willPublish = willPublish;
        }

        @Nullable
        public MqttSimpleAuth getSimpleAuth() {
            return this.simpleAuth;
        }

        @Nullable
        public Mqtt5EnhancedAuthMechanism getEnhancedAuthMechanism() {
            return this.enhancedAuthMechanism;
        }

        @Nullable
        public MqttWillPublish getWillPublish() {
            return this.willPublish;
        }
    }
}

