/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.client.internal.mqtt;

import com.hivemq.client.internal.mqtt.MqttClientExecutorConfigImplBuilder;
import com.hivemq.client.internal.shaded.org.jetbrains.annotations.NotNull;
import com.hivemq.client.internal.shaded.org.jetbrains.annotations.Nullable;
import com.hivemq.client.mqtt.MqttClientExecutorConfig;
import io.reactivex.Scheduler;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.concurrent.Executor;

public class MqttClientExecutorConfigImpl
implements MqttClientExecutorConfig {
    public static final int DEFAULT_NETTY_THREADS = 0;
    @NotNull
    public static final MqttClientExecutorConfigImpl DEFAULT = new MqttClientExecutorConfigImpl(null, 0, DEFAULT_APPLICATION_SCHEDULER);
    @Nullable
    private final Executor nettyExecutor;
    private final int nettyThreads;
    @NotNull
    private final Scheduler applicationScheduler;

    MqttClientExecutorConfigImpl(@Nullable Executor nettyExecutor, int nettyThreads, @NotNull Scheduler applicationScheduler) {
        this.nettyExecutor = nettyExecutor;
        this.nettyThreads = nettyThreads;
        this.applicationScheduler = applicationScheduler;
    }

    @Override
    @NotNull
    public Optional<Executor> getNettyExecutor() {
        return Optional.ofNullable(this.nettyExecutor);
    }

    @Nullable
    public Executor getRawNettyExecutor() {
        return this.nettyExecutor;
    }

    @Override
    @NotNull
    public OptionalInt getNettyThreads() {
        return this.nettyThreads == 0 ? OptionalInt.empty() : OptionalInt.of(this.nettyThreads);
    }

    public int getRawNettyThreads() {
        return this.nettyThreads;
    }

    @Override
    @NotNull
    public Scheduler getApplicationScheduler() {
        return this.applicationScheduler;
    }

    @Override
    public @NotNull MqttClientExecutorConfigImplBuilder.Default extend() {
        return new MqttClientExecutorConfigImplBuilder.Default(this);
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MqttClientExecutorConfigImpl)) {
            return false;
        }
        MqttClientExecutorConfigImpl that = (MqttClientExecutorConfigImpl)o;
        return Objects.equals(this.nettyExecutor, that.nettyExecutor) && this.nettyThreads == that.nettyThreads && this.applicationScheduler.equals(that.applicationScheduler);
    }

    public int hashCode() {
        int result = Objects.hashCode(this.nettyExecutor);
        result = 31 * result + this.nettyThreads;
        result = 31 * result + this.applicationScheduler.hashCode();
        return result;
    }
}

