/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.client.internal.mqtt.advanced;

import com.hivemq.client.internal.mqtt.advanced.MqttClientAdvancedConfig;
import com.hivemq.client.internal.mqtt.advanced.interceptor.MqttClientInterceptors;
import com.hivemq.client.internal.mqtt.advanced.interceptor.MqttClientInterceptorsBuilder;
import com.hivemq.client.internal.shaded.org.jetbrains.annotations.NotNull;
import com.hivemq.client.internal.shaded.org.jetbrains.annotations.Nullable;
import com.hivemq.client.internal.util.Checks;
import com.hivemq.client.mqtt.mqtt5.advanced.Mqtt5ClientAdvancedConfigBuilder;
import com.hivemq.client.mqtt.mqtt5.advanced.interceptor.Mqtt5ClientInterceptors;
import java.util.function.Function;

public abstract class MqttClientAdvancedConfigBuilder<B extends MqttClientAdvancedConfigBuilder<B>> {
    private boolean allowServerReAuth;
    private boolean validatePayloadFormat;
    @Nullable
    private MqttClientInterceptors interceptors;

    MqttClientAdvancedConfigBuilder() {
    }

    MqttClientAdvancedConfigBuilder(@NotNull MqttClientAdvancedConfig advancedConfig) {
        this.allowServerReAuth = advancedConfig.isAllowServerReAuth();
        this.validatePayloadFormat = advancedConfig.isValidatePayloadFormat();
        this.interceptors = advancedConfig.getInterceptors();
    }

    @NotNull
    abstract B self();

    @NotNull
    public B allowServerReAuth(boolean allowServerReAuth) {
        this.allowServerReAuth = allowServerReAuth;
        return this.self();
    }

    @NotNull
    public B validatePayloadFormat(boolean validatePayloadFormat) {
        this.validatePayloadFormat = validatePayloadFormat;
        return this.self();
    }

    @NotNull
    public B interceptors(@Nullable Mqtt5ClientInterceptors interceptors) {
        this.interceptors = Checks.notImplementedOrNull(interceptors, MqttClientInterceptors.class, "Interceptors");
        return this.self();
    }

    public  @NotNull MqttClientInterceptorsBuilder.Nested<B> interceptors() {
        return new MqttClientInterceptorsBuilder.Nested<MqttClientAdvancedConfigBuilder>(this.interceptors, this::interceptors);
    }

    @NotNull
    public MqttClientAdvancedConfig build() {
        return new MqttClientAdvancedConfig(this.allowServerReAuth, this.validatePayloadFormat, this.interceptors);
    }

    public static class Nested<P>
    extends MqttClientAdvancedConfigBuilder<Nested<P>>
    implements Mqtt5ClientAdvancedConfigBuilder.Nested<P> {
        @NotNull
        private final Function<? super MqttClientAdvancedConfig, P> parentConsumer;

        public Nested(@NotNull MqttClientAdvancedConfig advancedConfig, @NotNull Function<? super MqttClientAdvancedConfig, P> parentConsumer) {
            super(advancedConfig);
            this.parentConsumer = parentConsumer;
        }

        @Override
        @NotNull
        Nested<P> self() {
            return this;
        }

        @Override
        @NotNull
        public P applyAdvancedConfig() {
            return this.parentConsumer.apply(this.build());
        }
    }

    public static class Default
    extends MqttClientAdvancedConfigBuilder<Default>
    implements Mqtt5ClientAdvancedConfigBuilder {
        public Default() {
        }

        Default(@NotNull MqttClientAdvancedConfig advancedConfig) {
            super(advancedConfig);
        }

        @Override
        @NotNull
        Default self() {
            return this;
        }
    }
}

