/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.client.internal.mqtt.codec.decoder;

import com.hivemq.client.internal.mqtt.MqttClientConfig;
import com.hivemq.client.internal.mqtt.codec.decoder.MqttDecoderContext;
import com.hivemq.client.internal.mqtt.codec.decoder.MqttDecoderException;
import com.hivemq.client.internal.mqtt.codec.decoder.MqttMessageDecoder;
import com.hivemq.client.internal.mqtt.codec.decoder.MqttMessageDecoders;
import com.hivemq.client.internal.mqtt.datatypes.MqttVariableByteInteger;
import com.hivemq.client.internal.mqtt.handler.disconnect.MqttDisconnectUtil;
import com.hivemq.client.internal.mqtt.ioc.ConnectionScope;
import com.hivemq.client.internal.mqtt.message.connect.MqttConnect;
import com.hivemq.client.internal.mqtt.message.connect.MqttConnectRestrictions;
import com.hivemq.client.internal.shaded.io.netty.buffer.ByteBuf;
import com.hivemq.client.internal.shaded.io.netty.channel.ChannelHandlerContext;
import com.hivemq.client.internal.shaded.io.netty.handler.codec.ByteToMessageDecoder;
import com.hivemq.client.internal.shaded.javax.inject.Inject;
import com.hivemq.client.internal.shaded.org.jetbrains.annotations.NotNull;
import com.hivemq.client.mqtt.exceptions.MqttDecodeException;
import com.hivemq.client.mqtt.mqtt5.message.Mqtt5MessageType;
import com.hivemq.client.mqtt.mqtt5.message.disconnect.Mqtt5DisconnectReasonCode;
import java.util.List;

@ConnectionScope
public class MqttDecoder
extends ByteToMessageDecoder {
    @NotNull
    public static final String NAME = "decoder";
    private static final int MIN_FIXED_HEADER_LENGTH = 2;
    @NotNull
    private final MqttMessageDecoders decoders;
    @NotNull
    private final MqttDecoderContext context;

    @Inject
    MqttDecoder(@NotNull MqttMessageDecoders decoders, @NotNull MqttClientConfig clientConfig, @NotNull MqttConnect connect) {
        this.decoders = decoders;
        MqttConnectRestrictions restrictions = connect.getRestrictions();
        this.context = new MqttDecoderContext(restrictions.getMaximumPacketSize(), restrictions.getTopicAliasMaximum(), restrictions.isRequestProblemInformation(), restrictions.isRequestResponseInformation(), clientConfig.getAdvancedConfig().isValidatePayloadFormat(), false, false, false);
    }

    @Override
    protected void decode(@NotNull ChannelHandlerContext ctx, @NotNull ByteBuf in, @NotNull List<Object> out) {
        if (in.readableBytes() < 2) {
            return;
        }
        int readerIndexBeforeFixedHeader = in.readerIndex();
        short fixedHeader = in.readUnsignedByte();
        int messageType = fixedHeader >> 4;
        int flags = fixedHeader & 0xF;
        int remainingLength = MqttVariableByteInteger.decode(in);
        try {
            if (remainingLength < 0) {
                if (remainingLength == -1) {
                    in.readerIndex(readerIndexBeforeFixedHeader);
                    return;
                }
                throw new MqttDecoderException("malformed remaining length");
            }
            int readerIndexAfterFixedHeader = in.readerIndex();
            int fixedHeaderLength = readerIndexAfterFixedHeader - readerIndexBeforeFixedHeader;
            int packetSize = fixedHeaderLength + remainingLength;
            if (packetSize > this.context.getMaximumPacketSize()) {
                throw new MqttDecoderException(Mqtt5DisconnectReasonCode.PACKET_TOO_LARGE, "incoming packet exceeded maximum packet size");
            }
            int writerIndex = in.writerIndex();
            if (writerIndex < readerIndexAfterFixedHeader + remainingLength) {
                in.readerIndex(readerIndexBeforeFixedHeader);
                return;
            }
            MqttMessageDecoder decoder = this.decoders.get(messageType);
            if (decoder == null) {
                throw new MqttDecoderException(Mqtt5DisconnectReasonCode.PROTOCOL_ERROR, "must not receive this packet type");
            }
            in.writerIndex(readerIndexAfterFixedHeader + remainingLength);
            out.add(decoder.decode(flags, in, this.context));
            in.writerIndex(writerIndex);
        }
        catch (MqttDecoderException e) {
            in.clear();
            Mqtt5MessageType type = Mqtt5MessageType.fromCode(messageType);
            String message = "Exception while decoding " + (type == null ? "UNKNOWN" : type) + ": " + e.getMessage();
            MqttDisconnectUtil.disconnect(ctx.channel(), e.getReasonCode(), new MqttDecodeException(message));
        }
    }

    @Override
    public boolean isSharable() {
        return false;
    }
}

