/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.client.internal.mqtt.codec.decoder;

import com.hivemq.client.internal.mqtt.datatypes.MqttTopicImpl;
import com.hivemq.client.internal.shaded.org.jetbrains.annotations.Nullable;

public class MqttDecoderContext {
    private final int maximumPacketSize;
    @Nullable
    private final @Nullable MqttTopicImpl @Nullable [] topicAliasMapping;
    private final boolean problemInformationRequested;
    private final boolean responseInformationRequested;
    private final boolean validatePayloadFormat;
    private final boolean directBufferPayload;
    private final boolean directBufferAuth;
    private final boolean directBufferCorrelationData;

    MqttDecoderContext(int maximumPacketSize, int topicAliasMaximum, boolean problemInformationRequested, boolean responseInformationRequested, boolean validatePayloadFormat, boolean directBufferPayload, boolean directBufferAuth, boolean directBufferCorrelationData) {
        this.maximumPacketSize = maximumPacketSize;
        this.topicAliasMapping = topicAliasMaximum == 0 ? null : new MqttTopicImpl[topicAliasMaximum];
        this.problemInformationRequested = problemInformationRequested;
        this.responseInformationRequested = responseInformationRequested;
        this.validatePayloadFormat = validatePayloadFormat;
        this.directBufferPayload = directBufferPayload;
        this.directBufferAuth = directBufferAuth;
        this.directBufferCorrelationData = directBufferCorrelationData;
    }

    public int getMaximumPacketSize() {
        return this.maximumPacketSize;
    }

    @Nullable
    public @Nullable MqttTopicImpl @Nullable [] getTopicAliasMapping() {
        return this.topicAliasMapping;
    }

    public boolean isProblemInformationRequested() {
        return this.problemInformationRequested;
    }

    public boolean isResponseInformationRequested() {
        return this.responseInformationRequested;
    }

    public boolean validatePayloadFormat() {
        return this.validatePayloadFormat;
    }

    public boolean useDirectBufferPayload() {
        return this.directBufferPayload;
    }

    public boolean useDirectBufferAuth() {
        return this.directBufferAuth;
    }

    public boolean useDirectBufferCorrelationData() {
        return this.directBufferCorrelationData;
    }
}

