/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.client.internal.mqtt.codec.encoder.mqtt3;

import com.hivemq.client.internal.mqtt.codec.encoder.MqttEncoderContext;
import com.hivemq.client.internal.mqtt.codec.encoder.MqttMessageEncoder;
import com.hivemq.client.internal.mqtt.codec.encoder.MqttMessageEncoderUtil;
import com.hivemq.client.internal.mqtt.message.MqttMessage;
import com.hivemq.client.internal.shaded.io.netty.buffer.ByteBuf;
import com.hivemq.client.internal.shaded.org.jetbrains.annotations.NotNull;

abstract class Mqtt3MessageEncoder<M extends MqttMessage>
extends MqttMessageEncoder<M> {
    Mqtt3MessageEncoder() {
    }

    @Override
    @NotNull
    protected ByteBuf encode(@NotNull M message, @NotNull MqttEncoderContext context) {
        int remainingLength = this.remainingLength(message);
        int encodedLength = MqttMessageEncoderUtil.encodedPacketLength(remainingLength);
        if (encodedLength > context.getMaximumPacketSize()) {
            throw MqttMessageEncoderUtil.maximumPacketSizeExceeded(message, encodedLength, context.getMaximumPacketSize());
        }
        return this.encode(message, context, encodedLength, remainingLength);
    }

    @NotNull
    ByteBuf encode(@NotNull M message, @NotNull MqttEncoderContext context, int encodedLength, int remainingLength) {
        ByteBuf out = context.getAllocator().ioBuffer(encodedLength, encodedLength);
        this.encode(message, out, remainingLength);
        return out;
    }

    abstract void encode(@NotNull M var1, @NotNull ByteBuf var2, int var3);

    abstract int remainingLength(@NotNull M var1);

    static abstract class Mqtt3MessageWithIdEncoder<M extends MqttMessage.WithId>
    extends MqttMessageEncoder<M> {
        private static final int REMAINING_LENGTH = 2;
        private static final int ENCODED_LENGTH = 4;

        Mqtt3MessageWithIdEncoder() {
        }

        @Override
        @NotNull
        protected ByteBuf encode(@NotNull M message, @NotNull MqttEncoderContext context) {
            if (4 > context.getMaximumPacketSize()) {
                throw MqttMessageEncoderUtil.maximumPacketSizeExceeded(message, 4, context.getMaximumPacketSize());
            }
            ByteBuf out = context.getAllocator().ioBuffer(4, 4);
            this.encode(message, out);
            return out;
        }

        private void encode(@NotNull M message, @NotNull ByteBuf out) {
            this.encodeFixedHeader(out);
            this.encodeVariableHeader(message, out);
        }

        private void encodeFixedHeader(@NotNull ByteBuf out) {
            out.writeByte(this.getFixedHeader());
            out.writeByte(2);
        }

        private void encodeVariableHeader(@NotNull M message, @NotNull ByteBuf out) {
            out.writeShort(message.getPacketIdentifier());
        }

        abstract int getFixedHeader();
    }
}

