/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.client.internal.mqtt.codec.encoder.mqtt5;

import com.hivemq.client.internal.mqtt.codec.encoder.mqtt5.Mqtt5MessageEncoderUtil;
import com.hivemq.client.internal.mqtt.codec.encoder.mqtt5.Mqtt5MessageWithUserPropertiesEncoder;
import com.hivemq.client.internal.mqtt.datatypes.MqttVariableByteInteger;
import com.hivemq.client.internal.mqtt.message.auth.MqttAuth;
import com.hivemq.client.internal.shaded.io.netty.buffer.ByteBuf;
import com.hivemq.client.internal.shaded.javax.inject.Inject;
import com.hivemq.client.internal.shaded.javax.inject.Singleton;
import com.hivemq.client.internal.shaded.org.jetbrains.annotations.NotNull;
import com.hivemq.client.mqtt.mqtt5.message.Mqtt5MessageType;
import com.hivemq.client.mqtt.mqtt5.message.auth.Mqtt5AuthReasonCode;

@Singleton
public class Mqtt5AuthEncoder
extends Mqtt5MessageWithUserPropertiesEncoder.WithReason<MqttAuth> {
    private static final int FIXED_HEADER = Mqtt5MessageType.AUTH.getCode() << 4;
    private static final int VARIABLE_HEADER_FIXED_LENGTH = 1;

    @Inject
    Mqtt5AuthEncoder() {
    }

    @Override
    int remainingLengthWithoutProperties(@NotNull MqttAuth message) {
        return 1;
    }

    @Override
    int propertyLength(@NotNull MqttAuth message) {
        int propertyLength = 0;
        propertyLength += Mqtt5MessageEncoderUtil.propertyEncodedLength(message.getMethod());
        propertyLength += Mqtt5MessageEncoderUtil.nullablePropertyEncodedLength(message.getRawData());
        return propertyLength += this.omissiblePropertyLength(message);
    }

    @Override
    void encode(@NotNull MqttAuth message, @NotNull ByteBuf out, int remainingLength, int propertyLength, int omittedProperties) {
        this.encodeFixedHeader(out, remainingLength);
        this.encodeVariableHeader(message, out, propertyLength, omittedProperties);
    }

    private void encodeFixedHeader(@NotNull ByteBuf out, int remainingLength) {
        out.writeByte(FIXED_HEADER);
        MqttVariableByteInteger.encode(remainingLength, out);
    }

    private void encodeVariableHeader(@NotNull MqttAuth message, @NotNull ByteBuf out, int propertyLength, int omittedProperties) {
        out.writeByte(((Mqtt5AuthReasonCode)message.getReasonCode()).getCode());
        this.encodeProperties(message, out, propertyLength, omittedProperties);
    }

    private void encodeProperties(@NotNull MqttAuth message, @NotNull ByteBuf out, int propertyLength, int omittedProperties) {
        MqttVariableByteInteger.encode(propertyLength, out);
        Mqtt5MessageEncoderUtil.encodeProperty(21, message.getMethod(), out);
        Mqtt5MessageEncoderUtil.encodeNullableProperty(22, message.getRawData(), out);
        this.encodeOmissibleProperties(message, out, omittedProperties);
    }
}

