/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.client.internal.mqtt.handler;

import com.hivemq.client.internal.mqtt.MqttClientConfig;
import com.hivemq.client.internal.mqtt.MqttClientSslConfigImpl;
import com.hivemq.client.internal.mqtt.MqttProxyConfigImpl;
import com.hivemq.client.internal.mqtt.MqttWebSocketConfigImpl;
import com.hivemq.client.internal.mqtt.codec.encoder.MqttEncoder;
import com.hivemq.client.internal.mqtt.handler.auth.MqttAuthHandler;
import com.hivemq.client.internal.mqtt.handler.connect.MqttConnAckFlow;
import com.hivemq.client.internal.mqtt.handler.connect.MqttConnAckSingle;
import com.hivemq.client.internal.mqtt.handler.connect.MqttConnectHandler;
import com.hivemq.client.internal.mqtt.handler.disconnect.MqttDisconnectHandler;
import com.hivemq.client.internal.mqtt.handler.proxy.MqttProxyInitializer;
import com.hivemq.client.internal.mqtt.handler.ssl.MqttSslInitializer;
import com.hivemq.client.internal.mqtt.handler.websocket.MqttWebSocketInitializer;
import com.hivemq.client.internal.mqtt.ioc.ConnectionScope;
import com.hivemq.client.internal.mqtt.message.connect.MqttConnect;
import com.hivemq.client.internal.shaded.dagger.Lazy;
import com.hivemq.client.internal.shaded.io.netty.channel.Channel;
import com.hivemq.client.internal.shaded.io.netty.channel.ChannelHandler;
import com.hivemq.client.internal.shaded.io.netty.channel.ChannelHandlerContext;
import com.hivemq.client.internal.shaded.io.netty.channel.ChannelInboundHandlerAdapter;
import com.hivemq.client.internal.shaded.io.netty.channel.socket.SocketChannel;
import com.hivemq.client.internal.shaded.javax.inject.Inject;
import com.hivemq.client.internal.shaded.org.jetbrains.annotations.NotNull;
import com.hivemq.client.mqtt.exceptions.ConnectionFailedException;
import com.hivemq.client.mqtt.lifecycle.MqttDisconnectSource;

@ConnectionScope
public class MqttChannelInitializer
extends ChannelInboundHandlerAdapter {
    @NotNull
    private final MqttClientConfig clientConfig;
    @NotNull
    private final MqttConnect connect;
    @NotNull
    private final MqttConnAckFlow connAckFlow;
    @NotNull
    private final MqttEncoder encoder;
    @NotNull
    private final MqttConnectHandler connectHandler;
    @NotNull
    private final MqttDisconnectHandler disconnectHandler;
    @NotNull
    private final MqttAuthHandler authHandler;
    @NotNull
    private final Lazy<MqttWebSocketInitializer> webSocketInitializer;

    @Inject
    MqttChannelInitializer(@NotNull MqttClientConfig clientConfig, @NotNull MqttConnect connect, @NotNull MqttConnAckFlow connAckFlow, @NotNull MqttEncoder encoder, @NotNull MqttConnectHandler connectHandler, @NotNull MqttDisconnectHandler disconnectHandler, @NotNull MqttAuthHandler authHandler, @NotNull Lazy<MqttWebSocketInitializer> webSocketInitializer) {
        this.clientConfig = clientConfig;
        this.connect = connect;
        this.connAckFlow = connAckFlow;
        this.encoder = encoder;
        this.connectHandler = connectHandler;
        this.disconnectHandler = disconnectHandler;
        this.authHandler = authHandler;
        this.webSocketInitializer = webSocketInitializer;
    }

    @Override
    public void handlerAdded(@NotNull ChannelHandlerContext ctx) {
        ctx.pipeline().remove(this);
        ((SocketChannel)ctx.channel()).config().setAutoClose(false).setKeepAlive(true).setTcpNoDelay(true).setConnectTimeoutMillis(this.clientConfig.getCurrentTransportConfig().getSocketConnectTimeoutMs());
        this.initProxy(ctx.channel());
    }

    private void initProxy(@NotNull Channel channel) {
        MqttProxyConfigImpl proxyConfig = this.clientConfig.getCurrentTransportConfig().getRawProxyConfig();
        if (proxyConfig == null) {
            this.initSsl(channel);
        } else {
            MqttProxyInitializer.initChannel(channel, this.clientConfig, proxyConfig, this::initSsl, this::onError);
        }
    }

    private void initSsl(@NotNull Channel channel) {
        MqttClientSslConfigImpl sslConfig = this.clientConfig.getCurrentTransportConfig().getRawSslConfig();
        if (sslConfig == null) {
            this.initWebsocket(channel);
        } else {
            MqttSslInitializer.initChannel(channel, this.clientConfig, sslConfig, this::initWebsocket, this::onError);
        }
    }

    private void initWebsocket(@NotNull Channel channel) {
        MqttWebSocketConfigImpl webSocketConfig = this.clientConfig.getCurrentTransportConfig().getRawWebSocketConfig();
        if (webSocketConfig == null) {
            this.initMqtt(channel);
        } else {
            this.webSocketInitializer.get().initChannel(channel, this.clientConfig, webSocketConfig, this::initMqtt, this::onError);
        }
    }

    private void initMqtt(@NotNull Channel channel) {
        channel.pipeline().addLast("encoder", (ChannelHandler)this.encoder).addLast("auth", (ChannelHandler)this.authHandler).addLast("connect", (ChannelHandler)this.connectHandler).addLast("disconnect", (ChannelHandler)this.disconnectHandler);
    }

    private void onError(@NotNull Channel channel, @NotNull Throwable cause) {
        channel.close();
        MqttConnAckSingle.reconnect(this.clientConfig, MqttDisconnectSource.CLIENT, new ConnectionFailedException(cause), this.connect, this.connAckFlow, channel.eventLoop());
    }

    @Override
    public boolean isSharable() {
        return false;
    }
}

