/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.client.internal.mqtt.handler.connect;

import com.hivemq.client.internal.logging.InternalLogger;
import com.hivemq.client.internal.logging.InternalLoggerFactory;
import com.hivemq.client.internal.mqtt.MqttClientConfig;
import com.hivemq.client.internal.mqtt.MqttClientTransportConfigImpl;
import com.hivemq.client.internal.mqtt.exceptions.MqttClientStateExceptions;
import com.hivemq.client.internal.mqtt.handler.connect.MqttConnAckFlow;
import com.hivemq.client.internal.mqtt.lifecycle.MqttClientDisconnectedContextImpl;
import com.hivemq.client.internal.mqtt.lifecycle.MqttClientReconnector;
import com.hivemq.client.internal.mqtt.message.connect.MqttConnect;
import com.hivemq.client.internal.shaded.io.netty.bootstrap.Bootstrap;
import com.hivemq.client.internal.shaded.io.netty.channel.EventLoop;
import com.hivemq.client.internal.shaded.io.netty.util.concurrent.Future;
import com.hivemq.client.internal.shaded.io.netty.util.concurrent.GenericFutureListener;
import com.hivemq.client.internal.shaded.org.jetbrains.annotations.NotNull;
import com.hivemq.client.internal.shaded.org.jetbrains.annotations.Nullable;
import com.hivemq.client.mqtt.MqttClientState;
import com.hivemq.client.mqtt.exceptions.ConnectionFailedException;
import com.hivemq.client.mqtt.lifecycle.MqttClientDisconnectedContext;
import com.hivemq.client.mqtt.lifecycle.MqttClientDisconnectedListener;
import com.hivemq.client.mqtt.lifecycle.MqttDisconnectSource;
import com.hivemq.client.mqtt.mqtt5.message.connect.connack.Mqtt5ConnAck;
import io.reactivex.Single;
import io.reactivex.SingleObserver;
import io.reactivex.internal.disposables.EmptyDisposable;
import java.util.concurrent.TimeUnit;

public class MqttConnAckSingle
extends Single<Mqtt5ConnAck> {
    @NotNull
    private static final InternalLogger LOGGER = InternalLoggerFactory.getLogger(MqttConnAckSingle.class);
    @NotNull
    private final MqttClientConfig clientConfig;
    @NotNull
    private final MqttConnect connect;

    public MqttConnAckSingle(@NotNull MqttClientConfig clientConfig, @NotNull MqttConnect connect) {
        this.clientConfig = clientConfig;
        this.connect = connect.setDefaults(clientConfig);
    }

    protected void subscribeActual(@NotNull SingleObserver<? super Mqtt5ConnAck> observer) {
        if (!this.clientConfig.getRawState().compareAndSet(MqttClientState.DISCONNECTED, MqttClientState.CONNECTING)) {
            EmptyDisposable.error((Throwable)MqttClientStateExceptions.alreadyConnected(), observer);
            return;
        }
        MqttConnAckFlow flow = new MqttConnAckFlow(observer);
        observer.onSubscribe(flow.getDisposable());
        MqttConnAckSingle.connect(this.clientConfig, this.connect, flow, this.clientConfig.acquireEventLoop());
    }

    private static void connect(@NotNull MqttClientConfig clientConfig, @NotNull MqttConnect connect, @NotNull MqttConnAckFlow flow, @NotNull EventLoop eventLoop) {
        if (flow.getDisposable().isDisposed()) {
            clientConfig.releaseEventLoop();
            clientConfig.getRawState().set(MqttClientState.DISCONNECTED);
        } else {
            Bootstrap bootstrap = clientConfig.getClientComponent().connectionComponentBuilder().connect(connect).connAckFlow(flow).build().bootstrap();
            MqttClientTransportConfigImpl transportConfig = clientConfig.getCurrentTransportConfig();
            ((Bootstrap)bootstrap.group(eventLoop)).connect(transportConfig.getRemoteAddress(), transportConfig.getRawLocalAddress()).addListener((GenericFutureListener<? extends Future<? super Void>>)((GenericFutureListener<Future>)future -> {
                Throwable cause = future.cause();
                if (cause != null) {
                    ConnectionFailedException e = new ConnectionFailedException(cause);
                    if (eventLoop.inEventLoop()) {
                        MqttConnAckSingle.reconnect(clientConfig, MqttDisconnectSource.CLIENT, e, connect, flow, eventLoop);
                    } else {
                        eventLoop.execute(() -> MqttConnAckSingle.reconnect(clientConfig, MqttDisconnectSource.CLIENT, e, connect, flow, eventLoop));
                    }
                }
            }));
        }
    }

    public static void reconnect(@NotNull MqttClientConfig clientConfig, @NotNull MqttDisconnectSource source, @NotNull Throwable cause, @NotNull MqttConnect connect, @NotNull MqttConnAckFlow flow, @NotNull EventLoop eventLoop) {
        if (flow.setDone()) {
            MqttConnAckSingle.reconnect(clientConfig, source, cause, connect, flow.getAttempts() + 1, flow, eventLoop);
        }
    }

    public static void reconnect(@NotNull MqttClientConfig clientConfig, @NotNull MqttDisconnectSource source, @NotNull Throwable cause, @NotNull MqttConnect connect, @NotNull EventLoop eventLoop) {
        MqttConnAckSingle.reconnect(clientConfig, source, cause, connect, 0, null, eventLoop);
    }

    private static void reconnect(@NotNull MqttClientConfig clientConfig, @NotNull MqttDisconnectSource source, @NotNull Throwable cause, @NotNull MqttConnect connect, int attempts, @Nullable MqttConnAckFlow flow, @NotNull EventLoop eventLoop) {
        MqttClientReconnector reconnector = new MqttClientReconnector(eventLoop, attempts, connect, clientConfig.getCurrentTransportConfig());
        MqttClientDisconnectedContext context = MqttClientDisconnectedContextImpl.of(clientConfig, source, cause, reconnector);
        for (MqttClientDisconnectedListener disconnectedListener : clientConfig.getDisconnectedListeners()) {
            try {
                disconnectedListener.onDisconnected(context);
            }
            catch (Throwable t) {
                LOGGER.error("Unexpected exception thrown by disconnected listener.", t);
            }
        }
        if (reconnector.isReconnect()) {
            clientConfig.getRawState().set(MqttClientState.DISCONNECTED_RECONNECT);
            eventLoop.schedule(() -> reconnector.getFuture().whenComplete((ignored, throwable) -> {
                if (reconnector.isReconnect()) {
                    if (clientConfig.getRawState().compareAndSet(MqttClientState.DISCONNECTED_RECONNECT, MqttClientState.CONNECTING_RECONNECT)) {
                        clientConfig.setCurrentTransportConfig(reconnector.getTransportConfig());
                        MqttConnAckSingle.connect(clientConfig, reconnector.getConnect(), new MqttConnAckFlow(flow), eventLoop);
                    }
                } else if (clientConfig.getRawState().compareAndSet(MqttClientState.DISCONNECTED_RECONNECT, MqttClientState.DISCONNECTED)) {
                    clientConfig.releaseEventLoop();
                    if (flow != null) {
                        if (throwable == null) {
                            flow.onError(new ConnectionFailedException("Reconnect was cancelled."));
                        } else {
                            flow.onError(new ConnectionFailedException((Throwable)throwable));
                        }
                    }
                }
            }), reconnector.getDelay(TimeUnit.NANOSECONDS), TimeUnit.NANOSECONDS);
            clientConfig.setResubscribeIfSessionPresent(reconnector.isResubscribeIfSessionPresent());
            clientConfig.setResubscribeIfSessionExpired(reconnector.isResubscribeIfSessionExpired());
            clientConfig.setRepublishIfSessionExpired(reconnector.isRepublishIfSessionExpired());
            reconnector.afterOnDisconnected();
        } else {
            clientConfig.getRawState().set(MqttClientState.DISCONNECTED);
            clientConfig.releaseEventLoop();
            if (flow != null) {
                flow.onError(cause);
            }
        }
    }
}

