/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.client.internal.mqtt.handler.disconnect;

import com.hivemq.client.internal.mqtt.message.disconnect.MqttDisconnect;
import com.hivemq.client.internal.rx.CompletableFlow;
import com.hivemq.client.internal.shaded.org.jetbrains.annotations.NotNull;
import com.hivemq.client.internal.shaded.org.jetbrains.annotations.Nullable;
import com.hivemq.client.mqtt.lifecycle.MqttDisconnectSource;
import com.hivemq.client.mqtt.mqtt5.exceptions.Mqtt5DisconnectException;
import com.hivemq.client.mqtt.mqtt5.message.disconnect.Mqtt5Disconnect;

public class MqttDisconnectEvent {
    @NotNull
    private final Throwable cause;
    @NotNull
    private final MqttDisconnectSource source;

    MqttDisconnectEvent(@NotNull Throwable cause, @NotNull MqttDisconnectSource source) {
        this.cause = cause;
        this.source = source;
    }

    @NotNull
    public Throwable getCause() {
        return this.cause;
    }

    @NotNull
    public MqttDisconnectSource getSource() {
        return this.source;
    }

    @Nullable
    MqttDisconnect getDisconnect() {
        Mqtt5Disconnect mqttMessage;
        if (this.cause instanceof Mqtt5DisconnectException && (mqttMessage = ((Mqtt5DisconnectException)this.cause).getMqttMessage()) instanceof MqttDisconnect) {
            return (MqttDisconnect)mqttMessage;
        }
        return null;
    }

    static class ByUser
    extends MqttDisconnectEvent {
        @NotNull
        private final CompletableFlow flow;

        ByUser(@NotNull MqttDisconnect disconnect, @NotNull CompletableFlow flow) {
            super(new Mqtt5DisconnectException((Mqtt5Disconnect)disconnect, "Client sent DISCONNECT"), MqttDisconnectSource.USER);
            this.flow = flow;
        }

        @NotNull
        public CompletableFlow getFlow() {
            return this.flow;
        }
    }
}

