/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.client.internal.mqtt.handler.publish.incoming;

import com.hivemq.client.internal.mqtt.MqttClientConfig;
import com.hivemq.client.internal.mqtt.handler.publish.incoming.MqttGlobalIncomingPublishFlow;
import com.hivemq.client.internal.mqtt.handler.publish.incoming.MqttIncomingQosHandler;
import com.hivemq.client.internal.mqtt.handler.subscribe.MqttSubscriptionHandler;
import com.hivemq.client.internal.mqtt.ioc.ClientComponent;
import com.hivemq.client.internal.shaded.org.jetbrains.annotations.NotNull;
import com.hivemq.client.mqtt.MqttGlobalPublishFilter;
import com.hivemq.client.mqtt.mqtt5.message.publish.Mqtt5Publish;
import io.reactivex.Flowable;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public class MqttGlobalIncomingPublishFlowable
extends Flowable<Mqtt5Publish> {
    @NotNull
    private final MqttGlobalPublishFilter filter;
    @NotNull
    private final MqttClientConfig clientConfig;
    private final boolean manualAcknowledgement;

    public MqttGlobalIncomingPublishFlowable(@NotNull MqttGlobalPublishFilter filter, @NotNull MqttClientConfig clientConfig, boolean manualAcknowledgement) {
        this.filter = filter;
        this.clientConfig = clientConfig;
        this.manualAcknowledgement = manualAcknowledgement;
    }

    protected void subscribeActual(@NotNull Subscriber<? super Mqtt5Publish> subscriber) {
        ClientComponent clientComponent = this.clientConfig.getClientComponent();
        MqttIncomingQosHandler incomingQosHandler = clientComponent.incomingQosHandler();
        MqttSubscriptionHandler subscriptionHandler = clientComponent.subscriptionHandler();
        MqttGlobalIncomingPublishFlow flow = new MqttGlobalIncomingPublishFlow(subscriber, this.clientConfig, incomingQosHandler, this.filter, this.manualAcknowledgement);
        subscriber.onSubscribe((Subscription)flow);
        subscriptionHandler.subscribeGlobal(flow);
    }
}

