/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.client.internal.mqtt.handler.publish.incoming;

import com.hivemq.client.internal.annotations.NotThreadSafe;
import com.hivemq.client.internal.mqtt.datatypes.MqttTopicFilterImpl;
import com.hivemq.client.internal.mqtt.handler.publish.incoming.MqttGlobalIncomingPublishFlow;
import com.hivemq.client.internal.mqtt.handler.publish.incoming.MqttIncomingPublishFlow;
import com.hivemq.client.internal.mqtt.handler.publish.incoming.MqttStatefulPublishWithFlows;
import com.hivemq.client.internal.mqtt.handler.publish.incoming.MqttSubscribedPublishFlow;
import com.hivemq.client.internal.mqtt.handler.publish.incoming.MqttSubscribedPublishFlowTree;
import com.hivemq.client.internal.mqtt.handler.publish.incoming.MqttSubscribedPublishFlows;
import com.hivemq.client.internal.mqtt.ioc.ClientScope;
import com.hivemq.client.internal.mqtt.message.subscribe.MqttSubscribe;
import com.hivemq.client.internal.mqtt.message.subscribe.MqttSubscription;
import com.hivemq.client.internal.mqtt.message.unsubscribe.MqttUnsubscribe;
import com.hivemq.client.internal.mqtt.message.unsubscribe.unsuback.mqtt3.Mqtt3UnsubAckView;
import com.hivemq.client.internal.shaded.javax.inject.Inject;
import com.hivemq.client.internal.shaded.org.jetbrains.annotations.NotNull;
import com.hivemq.client.internal.shaded.org.jetbrains.annotations.Nullable;
import com.hivemq.client.internal.util.collections.HandleList;
import com.hivemq.client.internal.util.collections.ImmutableList;
import com.hivemq.client.mqtt.MqttGlobalPublishFilter;
import com.hivemq.client.mqtt.mqtt5.message.subscribe.suback.Mqtt5SubAckReasonCode;
import com.hivemq.client.mqtt.mqtt5.message.unsubscribe.unsuback.Mqtt5UnsubAckReasonCode;
import java.util.List;
import java.util.Map;

@ClientScope
@NotThreadSafe
public class MqttIncomingPublishFlows {
    @NotNull
    private final MqttSubscribedPublishFlows subscribedFlows = new MqttSubscribedPublishFlowTree();
    private final @Nullable HandleList<MqttGlobalIncomingPublishFlow> @NotNull [] globalFlows = new HandleList[MqttGlobalPublishFilter.values().length];

    @Inject
    MqttIncomingPublishFlows() {
    }

    public void subscribe(@NotNull MqttSubscribe subscribe, int subscriptionIdentifier, @Nullable MqttSubscribedPublishFlow flow) {
        List subscriptions = subscribe.getSubscriptions();
        for (int i = 0; i < subscriptions.size(); ++i) {
            this.subscribedFlows.subscribe((MqttSubscription)subscriptions.get(i), subscriptionIdentifier, flow);
        }
    }

    public void subAck(@NotNull MqttSubscribe subscribe, int subscriptionIdentifier, @NotNull ImmutableList<Mqtt5SubAckReasonCode> reasonCodes) {
        List subscriptions = subscribe.getSubscriptions();
        boolean countNotMatching = subscriptions.size() > reasonCodes.size();
        for (int i = 0; i < subscriptions.size(); ++i) {
            this.subscribedFlows.suback(((MqttSubscription)subscriptions.get(i)).getTopicFilter(), subscriptionIdentifier, countNotMatching || reasonCodes.get(i).isError());
        }
    }

    public void unsubscribe(@NotNull MqttUnsubscribe unsubscribe, @NotNull ImmutableList<Mqtt5UnsubAckReasonCode> reasonCodes) {
        List topicFilters = unsubscribe.getTopicFilters();
        boolean allSuccess = reasonCodes == Mqtt3UnsubAckView.REASON_CODES_ALL_SUCCESS;
        for (int i = 0; i < topicFilters.size(); ++i) {
            if (!allSuccess && reasonCodes.get(i).isError()) continue;
            this.subscribedFlows.unsubscribe((MqttTopicFilterImpl)topicFilters.get(i));
        }
    }

    void cancel(@NotNull MqttSubscribedPublishFlow flow) {
        this.subscribedFlows.cancel(flow);
    }

    public void subscribeGlobal(@NotNull MqttGlobalIncomingPublishFlow flow) {
        int filter = flow.getFilter().ordinal();
        HandleList<MqttGlobalIncomingPublishFlow> globalFlowsForFilter = this.globalFlows[filter];
        if (globalFlowsForFilter == null) {
            this.globalFlows[filter] = globalFlowsForFilter = new HandleList();
        }
        flow.setHandle(globalFlowsForFilter.add(flow));
    }

    void cancelGlobal(@NotNull MqttGlobalIncomingPublishFlow flow) {
        int filter = flow.getFilter().ordinal();
        HandleList<MqttGlobalIncomingPublishFlow> globalFlowsForFilter = this.globalFlows[filter];
        HandleList.Handle<MqttGlobalIncomingPublishFlow> handle = flow.getHandle();
        if (globalFlowsForFilter != null && handle != null) {
            globalFlowsForFilter.remove(handle);
            if (globalFlowsForFilter.isEmpty()) {
                this.globalFlows[filter] = null;
            }
        }
    }

    void findMatching(@NotNull MqttStatefulPublishWithFlows publishWithFlows) {
        this.subscribedFlows.findMatching(publishWithFlows);
        if (publishWithFlows.subscriptionFound) {
            MqttIncomingPublishFlows.add(publishWithFlows, this.globalFlows[MqttGlobalPublishFilter.SUBSCRIBED.ordinal()]);
        } else {
            MqttIncomingPublishFlows.add(publishWithFlows, this.globalFlows[MqttGlobalPublishFilter.UNSOLICITED.ordinal()]);
        }
        MqttIncomingPublishFlows.add(publishWithFlows, this.globalFlows[MqttGlobalPublishFilter.ALL.ordinal()]);
        if (publishWithFlows.isEmpty()) {
            MqttIncomingPublishFlows.add(publishWithFlows, this.globalFlows[MqttGlobalPublishFilter.REMAINING.ordinal()]);
        }
    }

    private static void add(@NotNull MqttStatefulPublishWithFlows publishWithFlows, @Nullable HandleList<MqttGlobalIncomingPublishFlow> globalFlows) {
        if (globalFlows != null) {
            for (HandleList.Handle h = (HandleList.Handle)globalFlows.getFirst(); h != null; h = (HandleList.Handle)h.getNext()) {
                publishWithFlows.add((MqttIncomingPublishFlow)h.getElement());
            }
        }
    }

    public void clear(@NotNull Throwable cause) {
        this.subscribedFlows.clear(cause);
        for (int i = 0; i < this.globalFlows.length; ++i) {
            HandleList<MqttGlobalIncomingPublishFlow> globalFlow = this.globalFlows[i];
            if (globalFlow != null) {
                for (HandleList.Handle h = (HandleList.Handle)globalFlow.getFirst(); h != null; h = (HandleList.Handle)h.getNext()) {
                    ((MqttGlobalIncomingPublishFlow)h.getElement()).onError(cause);
                }
            }
            this.globalFlows[i] = null;
        }
    }

    @NotNull
    public @NotNull Map<@NotNull Integer, @NotNull List<@NotNull MqttSubscription>> getSubscriptions() {
        return this.subscribedFlows.getSubscriptions();
    }
}

