/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.client.internal.mqtt.handler.publish.outgoing;

import com.hivemq.client.internal.logging.InternalLogger;
import com.hivemq.client.internal.logging.InternalLoggerFactory;
import com.hivemq.client.internal.mqtt.handler.publish.outgoing.MqttAckFlowableFlow;
import com.hivemq.client.internal.mqtt.handler.publish.outgoing.MqttPublishWithFlow;
import com.hivemq.client.internal.mqtt.message.publish.MqttPublish;
import com.hivemq.client.internal.shaded.org.jetbrains.annotations.NotNull;
import com.hivemq.client.internal.shaded.org.jetbrains.annotations.Nullable;
import io.reactivex.Flowable;
import io.reactivex.FlowableSubscriber;
import io.reactivex.plugins.RxJavaPlugins;
import java.util.concurrent.atomic.AtomicInteger;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public class MqttPublishFlowableAckLink
extends Flowable<MqttPublishWithFlow> {
    @NotNull
    private final Flowable<MqttPublish> source;
    @NotNull
    private final MqttAckFlowableFlow ackFlow;

    MqttPublishFlowableAckLink(@NotNull Flowable<MqttPublish> source, @NotNull MqttAckFlowableFlow ackFlow) {
        this.source = source;
        this.ackFlow = ackFlow;
    }

    protected void subscribeActual(@NotNull Subscriber<? super MqttPublishWithFlow> s) {
        this.source.subscribe((FlowableSubscriber)new AckLinkSubscriber(s, this.ackFlow));
    }

    private static class AckLinkSubscriber
    implements FlowableSubscriber<MqttPublish>,
    Subscription,
    LinkedFlow {
        @NotNull
        private static final InternalLogger LOGGER = InternalLoggerFactory.getLogger(AckLinkSubscriber.class);
        static final int STATE_NONE = 0;
        static final int STATE_IN_PROGRESS = 1;
        static final int STATE_DONE = 2;
        static final int STATE_CANCELLED = 3;
        @NotNull
        private final Subscriber<? super MqttPublishWithFlow> subscriber;
        @NotNull
        private final MqttAckFlowableFlow ackFlow;
        @Nullable
        private Subscription subscription;
        @NotNull
        private final AtomicInteger state = new AtomicInteger(0);
        @NotNull
        private final AtomicInteger requestState = new AtomicInteger(0);
        private long published;

        AckLinkSubscriber(@NotNull Subscriber<? super MqttPublishWithFlow> subscriber, @NotNull MqttAckFlowableFlow ackFlow) {
            this.subscriber = subscriber;
            this.ackFlow = ackFlow;
        }

        public void onSubscribe(@NotNull Subscription subscription) {
            this.subscription = subscription;
            this.subscriber.onSubscribe((Subscription)this);
            this.ackFlow.link(this);
        }

        public void onNext(@NotNull MqttPublish publish) {
            if (this.state.compareAndSet(0, 1)) {
                this.subscriber.onNext((Object)new MqttPublishWithFlow(publish, this.ackFlow));
                ++this.published;
                if (!this.state.compareAndSet(1, 0)) {
                    this.cancelActual();
                }
            }
        }

        public void onComplete() {
            if (this.state.compareAndSet(0, 2)) {
                this.subscriber.onComplete();
                this.ackFlow.onComplete(this.published);
            }
        }

        public void onError(@NotNull Throwable error) {
            if (this.state.compareAndSet(0, 2)) {
                this.subscriber.onComplete();
                this.ackFlow.onError(error, this.published);
            } else {
                RxJavaPlugins.onError((Throwable)error);
            }
        }

        public void request(long n) {
            assert (this.subscription != null);
            if (this.requestState.compareAndSet(0, 1)) {
                this.subscription.request(n);
                if (!this.requestState.compareAndSet(1, 0)) {
                    this.subscription.cancel();
                }
            }
        }

        public void cancel() {
            LOGGER.error("MqttPublishFlowables is global and must never cancel. This must not happen and is a bug.");
        }

        @Override
        public void cancelLink() {
            if (this.state.getAndSet(3) == 0) {
                this.cancelActual();
            }
        }

        private void cancelActual() {
            assert (this.subscription != null);
            if (this.requestState.getAndSet(3) == 0) {
                this.subscription.cancel();
            }
            this.subscriber.onComplete();
        }
    }

    static interface LinkedFlow {
        @NotNull
        public static final LinkedFlow CANCELLED = () -> {};

        public void cancelLink();
    }
}

