/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.client.internal.mqtt.handler.websocket;

import com.hivemq.client.internal.mqtt.handler.disconnect.MqttDisconnectUtil;
import com.hivemq.client.internal.shaded.io.netty.buffer.ByteBuf;
import com.hivemq.client.internal.shaded.io.netty.channel.ChannelDuplexHandler;
import com.hivemq.client.internal.shaded.io.netty.channel.ChannelHandler;
import com.hivemq.client.internal.shaded.io.netty.channel.ChannelHandlerContext;
import com.hivemq.client.internal.shaded.io.netty.channel.ChannelPromise;
import com.hivemq.client.internal.shaded.io.netty.handler.codec.http.websocketx.BinaryWebSocketFrame;
import com.hivemq.client.internal.shaded.io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import com.hivemq.client.internal.shaded.io.netty.handler.codec.http.websocketx.ContinuationWebSocketFrame;
import com.hivemq.client.internal.shaded.io.netty.handler.codec.http.websocketx.PingWebSocketFrame;
import com.hivemq.client.internal.shaded.io.netty.handler.codec.http.websocketx.PongWebSocketFrame;
import com.hivemq.client.internal.shaded.io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import com.hivemq.client.internal.shaded.io.netty.handler.codec.http.websocketx.WebSocketFrame;
import com.hivemq.client.internal.shaded.javax.inject.Inject;
import com.hivemq.client.internal.shaded.javax.inject.Singleton;
import com.hivemq.client.internal.shaded.org.jetbrains.annotations.NotNull;

@ChannelHandler.Sharable
@Singleton
public class MqttWebSocketCodec
extends ChannelDuplexHandler {
    @NotNull
    public static final String NAME = "ws.mqtt";

    @Inject
    MqttWebSocketCodec() {
    }

    @Override
    public void channelRead(@NotNull ChannelHandlerContext ctx, @NotNull Object msg) {
        if (msg instanceof WebSocketFrame) {
            WebSocketFrame webSocketFrame = (WebSocketFrame)msg;
            if (msg instanceof BinaryWebSocketFrame || msg instanceof ContinuationWebSocketFrame) {
                ctx.fireChannelRead(webSocketFrame.content());
            } else if (msg instanceof TextWebSocketFrame) {
                webSocketFrame.release();
                MqttDisconnectUtil.close(ctx.channel(), "Must not receive text websocket frames");
            } else if (msg instanceof CloseWebSocketFrame) {
                webSocketFrame.release();
                ctx.close();
            } else if (msg instanceof PingWebSocketFrame) {
                ctx.channel().writeAndFlush(new PongWebSocketFrame(webSocketFrame.content()));
            } else {
                webSocketFrame.release();
            }
        } else {
            ctx.fireChannelRead(msg);
        }
    }

    @Override
    public void write(@NotNull ChannelHandlerContext ctx, @NotNull Object msg, @NotNull ChannelPromise promise) {
        if (msg instanceof ByteBuf) {
            ctx.write(new BinaryWebSocketFrame((ByteBuf)msg), promise);
        } else {
            ctx.write(msg, promise);
        }
    }

    @Override
    public boolean isSharable() {
        return true;
    }
}

