/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.client.internal.mqtt.message;

import com.hivemq.client.internal.mqtt.datatypes.MqttUserPropertiesImpl;
import com.hivemq.client.internal.mqtt.message.MqttMessage;
import com.hivemq.client.internal.mqtt.message.MqttMessageWithUserProperties;
import com.hivemq.client.internal.shaded.org.jetbrains.annotations.NotNull;
import com.hivemq.client.mqtt.mqtt5.message.Mqtt5MessageType;

public abstract class MqttStatefulMessage<M extends MqttMessageWithUserProperties>
implements MqttMessage.WithUserProperties {
    @NotNull
    private final M statelessMessage;

    protected MqttStatefulMessage(@NotNull M statelessMessage) {
        this.statelessMessage = statelessMessage;
    }

    @Override
    @NotNull
    public Mqtt5MessageType getType() {
        return this.statelessMessage.getType();
    }

    @Override
    @NotNull
    public MqttUserPropertiesImpl getUserProperties() {
        return ((MqttMessageWithUserProperties)this.statelessMessage).getUserProperties();
    }

    @NotNull
    public M stateless() {
        return this.statelessMessage;
    }

    @NotNull
    protected String toAttributeString() {
        return "stateless=" + this.statelessMessage;
    }

    public static abstract class WithId<M extends MqttMessageWithUserProperties>
    extends MqttStatefulMessage<M>
    implements MqttMessage.WithId {
        private final int packetIdentifier;

        protected WithId(@NotNull M statelessMessage, int packetIdentifier) {
            super(statelessMessage);
            this.packetIdentifier = packetIdentifier;
        }

        @Override
        public int getPacketIdentifier() {
            return this.packetIdentifier;
        }

        @Override
        @NotNull
        protected String toAttributeString() {
            return super.toAttributeString() + ", packetIdentifier=" + this.packetIdentifier;
        }
    }
}

