/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.client.internal.mqtt.message.auth.mqtt3;

import com.hivemq.client.internal.mqtt.datatypes.MqttUtf8StringImpl;
import com.hivemq.client.internal.mqtt.message.auth.mqtt3.Mqtt3SimpleAuthView;
import com.hivemq.client.internal.mqtt.util.MqttChecks;
import com.hivemq.client.internal.shaded.org.jetbrains.annotations.NotNull;
import com.hivemq.client.internal.shaded.org.jetbrains.annotations.Nullable;
import com.hivemq.client.internal.util.Checks;
import com.hivemq.client.mqtt.datatypes.MqttUtf8String;
import com.hivemq.client.mqtt.mqtt3.message.auth.Mqtt3SimpleAuthBuilder;
import java.nio.ByteBuffer;
import java.util.function.Function;

public abstract class Mqtt3SimpleAuthViewBuilder<B extends Mqtt3SimpleAuthViewBuilder<B>> {
    @Nullable
    private MqttUtf8StringImpl username;
    @Nullable
    private ByteBuffer password;

    @NotNull
    abstract B self();

    @NotNull
    public B username(@Nullable String username) {
        this.username = MqttUtf8StringImpl.of(username, "Username");
        return this.self();
    }

    @NotNull
    public B username(@Nullable MqttUtf8String username) {
        this.username = MqttChecks.string(username, "Username");
        return this.self();
    }

    @NotNull
    public B password(byte @Nullable [] password) {
        this.password = MqttChecks.binaryData(password, "Password");
        return this.self();
    }

    @NotNull
    public B password(@Nullable ByteBuffer password) {
        this.password = MqttChecks.binaryData(password, "Password");
        return this.self();
    }

    @NotNull
    public Mqtt3SimpleAuthView build() {
        Checks.state(this.username != null, "Username must be given.");
        return Mqtt3SimpleAuthView.of(this.username, this.password);
    }

    public static class Nested<P>
    extends Mqtt3SimpleAuthViewBuilder<Nested<P>>
    implements Mqtt3SimpleAuthBuilder.Nested.Complete<P> {
        @NotNull
        private final Function<? super Mqtt3SimpleAuthView, P> parentConsumer;

        public Nested(@NotNull Function<? super Mqtt3SimpleAuthView, P> parentConsumer) {
            this.parentConsumer = parentConsumer;
        }

        @Override
        @NotNull
        Nested<P> self() {
            return this;
        }

        @Override
        @NotNull
        public P applySimpleAuth() {
            return this.parentConsumer.apply(this.build());
        }
    }

    public static class Default
    extends Mqtt3SimpleAuthViewBuilder<Default>
    implements Mqtt3SimpleAuthBuilder.Complete {
        @Override
        @NotNull
        Default self() {
            return this;
        }
    }
}

