/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.client.internal.mqtt.message.connect;

import com.hivemq.client.annotations.Immutable;
import com.hivemq.client.internal.mqtt.MqttClientConfig;
import com.hivemq.client.internal.mqtt.datatypes.MqttClientIdentifierImpl;
import com.hivemq.client.internal.mqtt.datatypes.MqttUserPropertiesImpl;
import com.hivemq.client.internal.mqtt.message.MqttMessageWithUserProperties;
import com.hivemq.client.internal.mqtt.message.auth.MqttEnhancedAuth;
import com.hivemq.client.internal.mqtt.message.auth.MqttSimpleAuth;
import com.hivemq.client.internal.mqtt.message.connect.MqttConnectBuilder;
import com.hivemq.client.internal.mqtt.message.connect.MqttConnectRestrictions;
import com.hivemq.client.internal.mqtt.message.connect.MqttStatefulConnect;
import com.hivemq.client.internal.mqtt.message.publish.MqttWillPublish;
import com.hivemq.client.internal.shaded.org.jetbrains.annotations.NotNull;
import com.hivemq.client.internal.shaded.org.jetbrains.annotations.Nullable;
import com.hivemq.client.internal.util.StringUtil;
import com.hivemq.client.mqtt.mqtt5.auth.Mqtt5EnhancedAuthMechanism;
import com.hivemq.client.mqtt.mqtt5.message.auth.Mqtt5SimpleAuth;
import com.hivemq.client.mqtt.mqtt5.message.connect.Mqtt5Connect;
import com.hivemq.client.mqtt.mqtt5.message.publish.Mqtt5WillPublish;
import java.util.Objects;
import java.util.Optional;

@Immutable
public class MqttConnect
extends MqttMessageWithUserProperties
implements Mqtt5Connect {
    @NotNull
    public static final MqttConnect DEFAULT = new MqttConnect(60, true, 0L, MqttConnectRestrictions.DEFAULT, null, null, null, MqttUserPropertiesImpl.NO_USER_PROPERTIES);
    private final int keepAlive;
    private final boolean cleanStart;
    private final long sessionExpiryInterval;
    @NotNull
    private final MqttConnectRestrictions restrictions;
    @Nullable
    private final MqttSimpleAuth simpleAuth;
    @Nullable
    private final Mqtt5EnhancedAuthMechanism enhancedAuthMechanism;
    @Nullable
    private final MqttWillPublish willPublish;

    public MqttConnect(int keepAlive, boolean cleanStart, long sessionExpiryInterval, @NotNull MqttConnectRestrictions restrictions, @Nullable MqttSimpleAuth simpleAuth, @Nullable Mqtt5EnhancedAuthMechanism enhancedAuthMechanism, @Nullable MqttWillPublish willPublish, @NotNull MqttUserPropertiesImpl userProperties) {
        super(userProperties);
        this.keepAlive = keepAlive;
        this.cleanStart = cleanStart;
        this.sessionExpiryInterval = sessionExpiryInterval;
        this.restrictions = restrictions;
        this.simpleAuth = simpleAuth;
        this.enhancedAuthMechanism = enhancedAuthMechanism;
        this.willPublish = willPublish;
    }

    @Override
    public int getKeepAlive() {
        return this.keepAlive;
    }

    @Override
    public boolean isCleanStart() {
        return this.cleanStart;
    }

    @Override
    public long getSessionExpiryInterval() {
        return this.sessionExpiryInterval;
    }

    @Override
    @NotNull
    public MqttConnectRestrictions getRestrictions() {
        return this.restrictions;
    }

    @Override
    @NotNull
    public Optional<Mqtt5SimpleAuth> getSimpleAuth() {
        return Optional.ofNullable(this.simpleAuth);
    }

    @Nullable
    public MqttSimpleAuth getRawSimpleAuth() {
        return this.simpleAuth;
    }

    @Override
    @NotNull
    public Optional<Mqtt5EnhancedAuthMechanism> getEnhancedAuthMechanism() {
        return Optional.ofNullable(this.enhancedAuthMechanism);
    }

    @Nullable
    public Mqtt5EnhancedAuthMechanism getRawEnhancedAuthMechanism() {
        return this.enhancedAuthMechanism;
    }

    @Override
    @NotNull
    public Optional<Mqtt5WillPublish> getWillPublish() {
        return Optional.ofNullable(this.willPublish);
    }

    @Nullable
    public MqttWillPublish getRawWillPublish() {
        return this.willPublish;
    }

    @Override
    public  @NotNull MqttConnectBuilder.Default extend() {
        return new MqttConnectBuilder.Default(this);
    }

    @NotNull
    public MqttConnect setDefaults(@NotNull MqttClientConfig clientConfig) {
        MqttClientConfig.ConnectDefaults connectDefaults = clientConfig.getConnectDefaults();
        MqttSimpleAuth defaultSimpleAuth = connectDefaults.getSimpleAuth();
        Mqtt5EnhancedAuthMechanism defaultEnhancedAuthMechanism = connectDefaults.getEnhancedAuthMechanism();
        MqttWillPublish defaultWillPublish = connectDefaults.getWillPublish();
        if (!(defaultSimpleAuth != null && this.simpleAuth == null || defaultEnhancedAuthMechanism != null && this.enhancedAuthMechanism == null || defaultWillPublish != null && this.willPublish == null)) {
            return this;
        }
        return new MqttConnect(this.keepAlive, this.cleanStart, this.sessionExpiryInterval, this.restrictions, this.simpleAuth == null ? defaultSimpleAuth : this.simpleAuth, this.enhancedAuthMechanism == null ? defaultEnhancedAuthMechanism : this.enhancedAuthMechanism, this.willPublish == null ? defaultWillPublish : this.willPublish, (MqttUserPropertiesImpl)this.getUserProperties());
    }

    @NotNull
    public MqttStatefulConnect createStateful(@NotNull MqttClientIdentifierImpl clientIdentifier, @Nullable MqttEnhancedAuth enhancedAuth) {
        return new MqttStatefulConnect(this, clientIdentifier, enhancedAuth);
    }

    @Override
    @NotNull
    protected String toAttributeString() {
        return "keepAlive=" + this.keepAlive + ", cleanStart=" + this.cleanStart + ", sessionExpiryInterval=" + this.sessionExpiryInterval + (this.restrictions == MqttConnectRestrictions.DEFAULT ? "" : ", restrictions=" + this.restrictions) + (this.simpleAuth == null ? "" : ", simpleAuth=" + this.simpleAuth) + (this.enhancedAuthMechanism == null ? "" : ", enhancedAuthMechanism=" + this.enhancedAuthMechanism) + (this.willPublish == null ? "" : ", willPublish=" + this.willPublish) + StringUtil.prepend(", ", super.toAttributeString());
    }

    @NotNull
    public String toString() {
        return "MqttConnect{" + this.toAttributeString() + '}';
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MqttConnect)) {
            return false;
        }
        MqttConnect that = (MqttConnect)o;
        return this.partialEquals(that) && this.keepAlive == that.keepAlive && this.cleanStart == that.cleanStart && this.sessionExpiryInterval == that.sessionExpiryInterval && this.restrictions.equals(that.restrictions) && Objects.equals(this.simpleAuth, that.simpleAuth) && Objects.equals(this.enhancedAuthMechanism, that.enhancedAuthMechanism) && Objects.equals(this.willPublish, that.willPublish);
    }

    public int hashCode() {
        int result = this.partialHashCode();
        result = 31 * result + this.keepAlive;
        result = 31 * result + Boolean.hashCode(this.cleanStart);
        result = 31 * result + Long.hashCode(this.sessionExpiryInterval);
        result = 31 * result + this.restrictions.hashCode();
        result = 31 * result + Objects.hashCode(this.simpleAuth);
        result = 31 * result + Objects.hashCode(this.enhancedAuthMechanism);
        result = 31 * result + Objects.hashCode(this.willPublish);
        return result;
    }
}

