/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.client.internal.mqtt.message.connect;

import com.hivemq.client.annotations.Immutable;
import com.hivemq.client.internal.mqtt.message.connect.MqttConnectRestrictionsBuilder;
import com.hivemq.client.internal.shaded.org.jetbrains.annotations.NotNull;
import com.hivemq.client.internal.shaded.org.jetbrains.annotations.Nullable;
import com.hivemq.client.mqtt.mqtt3.message.connect.Mqtt3ConnectRestrictions;
import com.hivemq.client.mqtt.mqtt5.message.connect.Mqtt5ConnectRestrictions;

@Immutable
public class MqttConnectRestrictions
implements Mqtt5ConnectRestrictions,
Mqtt3ConnectRestrictions {
    @NotNull
    public static final MqttConnectRestrictions DEFAULT = new MqttConnectRestrictions(65535, 65535, 0x10000004, 0x10000004, 0, 16, true, false);
    private final int receiveMaximum;
    private final int sendMaximum;
    private final int maximumPacketSize;
    private final int sendMaximumPacketSize;
    private final int topicAliasMaximum;
    private final int sendTopicAliasMaximum;
    private final boolean requestProblemInformation;
    private final boolean requestResponseInformation;

    public MqttConnectRestrictions(int receiveMaximum, int sendMaximum, int maximumPacketSize, int sendMaximumPacketSize, int topicAliasMaximum, int sendTopicAliasMaximum, boolean requestProblemInformation, boolean requestResponseInformation) {
        this.receiveMaximum = receiveMaximum;
        this.sendMaximum = sendMaximum;
        this.maximumPacketSize = maximumPacketSize;
        this.sendMaximumPacketSize = sendMaximumPacketSize;
        this.topicAliasMaximum = topicAliasMaximum;
        this.sendTopicAliasMaximum = sendTopicAliasMaximum;
        this.requestProblemInformation = requestProblemInformation;
        this.requestResponseInformation = requestResponseInformation;
    }

    @Override
    public int getReceiveMaximum() {
        return this.receiveMaximum;
    }

    @Override
    public int getSendMaximum() {
        return this.sendMaximum;
    }

    @Override
    public int getMaximumPacketSize() {
        return this.maximumPacketSize;
    }

    @Override
    public int getSendMaximumPacketSize() {
        return this.sendMaximumPacketSize;
    }

    @Override
    public int getTopicAliasMaximum() {
        return this.topicAliasMaximum;
    }

    @Override
    public int getSendTopicAliasMaximum() {
        return this.sendTopicAliasMaximum;
    }

    @Override
    public boolean isRequestProblemInformation() {
        return this.requestProblemInformation;
    }

    @Override
    public boolean isRequestResponseInformation() {
        return this.requestResponseInformation;
    }

    @Override
    @NotNull
    public MqttConnectRestrictionsBuilder.Default extend() {
        return new MqttConnectRestrictionsBuilder.Default(this);
    }

    @NotNull
    private String toAttributeString() {
        return "receiveMaximum=" + this.receiveMaximum + ", sendMaximum=" + this.sendMaximum + ", maximumPacketSize=" + this.maximumPacketSize + ", sendMaximumPacketSize=" + this.sendMaximumPacketSize + ", topicAliasMaximum=" + this.topicAliasMaximum + ", sendTopicAliasMaximum=" + this.sendTopicAliasMaximum + ", requestProblemInformation=" + this.requestProblemInformation + ", requestResponseInformation=" + this.requestResponseInformation;
    }

    @NotNull
    public String toString() {
        return "MqttConnectRestrictions{" + this.toAttributeString() + '}';
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MqttConnectRestrictions)) {
            return false;
        }
        MqttConnectRestrictions that = (MqttConnectRestrictions)o;
        return this.receiveMaximum == that.receiveMaximum && this.sendMaximum == that.sendMaximum && this.maximumPacketSize == that.maximumPacketSize && this.sendMaximumPacketSize == that.sendMaximumPacketSize && this.topicAliasMaximum == that.topicAliasMaximum && this.sendTopicAliasMaximum == that.sendTopicAliasMaximum && this.requestProblemInformation == that.requestProblemInformation && this.requestResponseInformation == that.requestResponseInformation;
    }

    public int hashCode() {
        int result = this.receiveMaximum;
        result = 31 * result + this.sendMaximum;
        result = 31 * result + this.maximumPacketSize;
        result = 31 * result + this.sendMaximumPacketSize;
        result = 31 * result + this.topicAliasMaximum;
        result = 31 * result + this.sendTopicAliasMaximum;
        result = 31 * result + Boolean.hashCode(this.requestProblemInformation);
        result = 31 * result + Boolean.hashCode(this.requestResponseInformation);
        return result;
    }
}

