/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.client.internal.mqtt.message.connect;

import com.hivemq.client.annotations.Immutable;
import com.hivemq.client.internal.mqtt.datatypes.MqttClientIdentifierImpl;
import com.hivemq.client.internal.mqtt.message.MqttStatefulMessage;
import com.hivemq.client.internal.mqtt.message.auth.MqttEnhancedAuth;
import com.hivemq.client.internal.mqtt.message.connect.MqttConnect;
import com.hivemq.client.internal.shaded.org.jetbrains.annotations.NotNull;
import com.hivemq.client.internal.shaded.org.jetbrains.annotations.Nullable;

@Immutable
public class MqttStatefulConnect
extends MqttStatefulMessage<MqttConnect> {
    @NotNull
    private final MqttClientIdentifierImpl clientIdentifier;
    @Nullable
    private final MqttEnhancedAuth enhancedAuth;

    MqttStatefulConnect(@NotNull MqttConnect connect, @NotNull MqttClientIdentifierImpl clientIdentifier, @Nullable MqttEnhancedAuth enhancedAuth) {
        super(connect);
        this.clientIdentifier = clientIdentifier;
        this.enhancedAuth = enhancedAuth;
    }

    @NotNull
    public MqttClientIdentifierImpl getClientIdentifier() {
        return this.clientIdentifier;
    }

    @Nullable
    public MqttEnhancedAuth getEnhancedAuth() {
        return this.enhancedAuth;
    }

    @Override
    @NotNull
    protected String toAttributeString() {
        return super.toAttributeString() + ", clientIdentifier=" + this.clientIdentifier + (this.enhancedAuth == null ? "" : ", enhancedAuth=" + this.enhancedAuth);
    }

    @NotNull
    public String toString() {
        return "MqttStatefulConnect{" + this.toAttributeString() + '}';
    }
}

