/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.client.internal.mqtt.message.subscribe;

import com.hivemq.client.annotations.Immutable;
import com.hivemq.client.internal.mqtt.datatypes.MqttUserPropertiesImpl;
import com.hivemq.client.internal.mqtt.message.MqttMessageWithUserProperties;
import com.hivemq.client.internal.mqtt.message.subscribe.MqttStatefulSubscribe;
import com.hivemq.client.internal.mqtt.message.subscribe.MqttSubscribeBuilder;
import com.hivemq.client.internal.mqtt.message.subscribe.MqttSubscription;
import com.hivemq.client.internal.shaded.org.jetbrains.annotations.NotNull;
import com.hivemq.client.internal.shaded.org.jetbrains.annotations.Nullable;
import com.hivemq.client.internal.util.StringUtil;
import com.hivemq.client.internal.util.collections.ImmutableList;
import com.hivemq.client.mqtt.mqtt5.message.subscribe.Mqtt5Subscribe;

@Immutable
public class MqttSubscribe
extends MqttMessageWithUserProperties
implements Mqtt5Subscribe {
    @NotNull
    private final ImmutableList<MqttSubscription> subscriptions;

    public MqttSubscribe(@NotNull ImmutableList<MqttSubscription> subscriptions, @NotNull MqttUserPropertiesImpl userProperties) {
        super(userProperties);
        this.subscriptions = subscriptions;
    }

    @NotNull
    public ImmutableList<MqttSubscription> getSubscriptions() {
        return this.subscriptions;
    }

    @NotNull
    public MqttStatefulSubscribe createStateful(int packetIdentifier, int subscriptionIdentifier) {
        return new MqttStatefulSubscribe(this, packetIdentifier, subscriptionIdentifier);
    }

    @Override
    public  @NotNull MqttSubscribeBuilder.Default extend() {
        return new MqttSubscribeBuilder.Default(this);
    }

    @Override
    @NotNull
    protected String toAttributeString() {
        return "subscriptions=" + this.subscriptions + StringUtil.prepend(", ", super.toAttributeString());
    }

    @NotNull
    public String toString() {
        return "MqttSubscribe{" + this.toAttributeString() + '}';
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MqttSubscribe)) {
            return false;
        }
        MqttSubscribe that = (MqttSubscribe)o;
        return this.partialEquals(that) && this.subscriptions.equals(that.subscriptions);
    }

    public int hashCode() {
        return 31 * this.partialHashCode() + this.subscriptions.hashCode();
    }
}

